/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.user.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.user.dto.UserFullInfoDto;
import com.rocogz.syy.user.dto.UserMsgWebDto;
import com.rocogz.syy.user.entity.RecommendCodeScanningRecord;
import com.rocogz.syy.user.entity.UserAuthenticationInfo;
import com.rocogz.syy.user.entity.UserBasicInfo;
import com.rocogz.syy.user.entity.UserCarInformation;
import com.rocogz.syy.user.entity.UserLoginCredentials;
import com.rocogz.syy.user.entity.UserLoginLog;
import com.rocogz.syy.user.entity.UserMsg;
import com.rocogz.syy.user.entity.UserRegisterInfo;
import com.rocogz.syy.user.entity.UserStoreCollection;
import com.rocogz.syy.user.entity.certificate.UserCertificateInfo;
import com.rocogz.syy.user.entity.certificate.UserDriverLicenceInfo;
import com.rocogz.syy.user.entity.certificate.UserDriveringLicenceInfo;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IUserClientService {
    @PostMapping(value={"/api/user/user-authentication-info"})
    public Response saveOrUpdateUserAuthenticationInfo(@RequestBody UserAuthenticationInfo var1);

    @PostMapping(value={"/api/user/user-authentication-info/updateByUserCode"})
    public Response updateUserAuthenticationInfoByUserCode(@RequestBody UserAuthenticationInfo var1);

    @GetMapping(value={"/api/user/user-authentication-info/getByUserCode"})
    public Response<UserAuthenticationInfo> getUserAuthenticationInfoByUserCode(@RequestParam(value="userCode") String var1);

    @GetMapping(value={"/api/user/user-authentication-info/getByMobile"})
    public Response<UserAuthenticationInfo> getUserAuthenticationInfoByMobile(@RequestParam(value="mobile") String var1);

    @GetMapping(value={"/api/user/user-authentication-info/getByEmail"})
    public Response<UserAuthenticationInfo> getUserAuthenticationInfoByEmail(@RequestParam(value="email") String var1);

    @GetMapping(value={"/api/user/user-authentication-info/getByIdTypeAndCard"})
    public Response<UserAuthenticationInfo> getUserAuthenticationInfoByIdTypeAndCard(@RequestParam(value="idType") String var1, @RequestParam(value="idCard") String var2);

    @GetMapping(value={"/api/user/user-full-info/getUserBasicAndAuthenticationInfo"})
    public Response<UserFullInfoDto> getUserBasicAndAuthenticationInfo(@RequestParam(value="mobile") String var1);

    @PostMapping(value={"/api/user/user-basic-info"})
    public Response<UserBasicInfo> saveOrUpdateUserBasicInfo(@RequestBody UserBasicInfo var1);

    @PostMapping(value={"/api/user/user-basic-info/updateByUserCode"})
    public Response updateUserBasicInfoByUserCode(@RequestBody UserBasicInfo var1);

    @GetMapping(value={"/api/user/user-basic-info/getByOpenid"})
    public Response<UserBasicInfo> getUserBasicInfoByOpenid(@RequestParam(value="openid") String var1);

    @GetMapping(value={"/api/user/user-basic-info/getByUserCode"})
    public Response<UserBasicInfo> getUserBasicInfoByUserCode(@RequestParam(value="userCode") String var1);

    @GetMapping(value={"/api/user/user-basic-info/getByMobile"})
    public Response<UserBasicInfo> getUserBasicInfoByMobile(@RequestParam(value="mobile") String var1);

    @GetMapping(value={"/api/user/user-basic-info/getByIdTypeAndCard"})
    public Response<UserBasicInfo> getUserBasicInfoByIdTypeAndCard(@RequestParam(value="idType") String var1, @RequestParam(value="idCard") String var2);

    @GetMapping(value={"/api/user/user-basic-info/getByUserCodeList"})
    public Response<List<UserBasicInfo>> getUserBasicInfoByUserCodeList(@NotNull @NotEmpty @RequestParam(value="userCodeList") List<String> var1);

    @GetMapping(value={"/api/user/user-basic-info/pageQuery"})
    public PageTable<UserBasicInfo> pageQueryUserBasicInfo(@RequestParam(value="userCode", required=false) String var1, @RequestParam(value="openid", required=false) String var2, @RequestParam(value="wxName", required=false) String var3, @RequestParam(value="mobile", required=false) String var4, @RequestParam(value="status", required=false) String var5, @RequestParam(value="startTime", required=false) String var6, @RequestParam(value="endTime", required=false) String var7, @RequestParam(value="page", defaultValue="1") Integer var8, @RequestParam(value="limit", defaultValue="20") Integer var9);

    @PostMapping(value={"/api/user/user-login-credentials"})
    public Response saveOrUpdateUserLoginCredentials(@RequestBody UserLoginCredentials var1);

    @PostMapping(value={"/api/user/user-login-credentials/updateByUserCode"})
    public Response updateUserLoginCredentialsByUserCode(@RequestBody UserLoginCredentials var1);

    @GetMapping(value={"/api/user/user-login-credentials/getByCredentials"})
    public Response<UserLoginCredentials> getUserLoginCredentialsByCredentials(@RequestParam(value="credentials") String var1, @RequestParam(value="type") String var2);

    @GetMapping(value={"/api/user/user-login-credentials/getByUserCode"})
    public Response<UserLoginCredentials> getUserLoginCredentialsByUserCode(@RequestParam(value="userCode") String var1);

    @PostMapping(value={"/api/user/user-register-info"})
    public Response saveOrUpdateUserRegisterInfo(@RequestBody UserRegisterInfo var1);

    @PostMapping(value={"/api/user/user-register-info/updateByUserCode"})
    public Response updateUserRegisterInfoByUserCode(@RequestBody UserRegisterInfo var1);

    @GetMapping(value={"/api/user/user-register-info/getByOpenid"})
    public Response<UserRegisterInfo> getUserRegisterInfoByOpenid(@RequestParam(value="openid") String var1);

    @GetMapping(value={"/api/user/user-register-info/getByUserCode"})
    public Response<UserRegisterInfo> getUserRegisterInfoByUserCode(@RequestParam(value="userCode") String var1);

    @PostMapping(value={"/api/user/user-store-collection"})
    public Response saveUserStoreCollection(@RequestBody UserStoreCollection var1);

    @GetMapping(value={"/api/user/user-store-collection/list"})
    public Response<List<UserStoreCollection>> listUserStoreCollection(@RequestParam(value="userCode", required=false) String var1, @RequestParam(value="storeCode", required=false) String var2);

    @DeleteMapping(value={"/api/user/user-store-collection/batchDelete"})
    public Response batchDeleteUserStoreCollection(@NotEmpty @RequestParam(value="userCode") String var1, @NotNull @NotEmpty @RequestParam(value="storeCodeList") List<String> var2);

    @DeleteMapping(value={"/api/user/user-store-collection"})
    public Response deleteUserStoreCollectionById(@NotNull @RequestParam(value="id") Integer var1);

    @PostMapping(value={"/api/user/user-login-log"})
    public Response saveUserLoginLog(@RequestBody UserLoginLog var1);

    @GetMapping(value={"/api/user/user-login-log/pageQuery"})
    public PageTable<UserLoginLog> pageQueryUserLoginLog(@RequestParam(value="userCode", required=false) String var1, @RequestParam(value="openid", required=false) String var2, @RequestParam(value="startTime", required=false) String var3, @RequestParam(value="endTime", required=false) String var4, @RequestParam(value="page", defaultValue="1") Integer var5, @RequestParam(value="limit", defaultValue="20") Integer var6);

    @PostMapping(value={"/api/user/certificateInfo/saveOrUpdateUserCertificateInfo"})
    public Response saveOrUpdateUserCertificateInfo(@RequestBody UserCertificateInfo var1);

    @GetMapping(value={"/api/user/certificateInfo/{id}"})
    public Response<UserCertificateInfo> getUserCertificateInfoById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/user/certificateInfo/getByUserCode/{userCode}"})
    public Response<UserCertificateInfo> getUserCertificateInfoByUserCode(@PathVariable(value="userCode") String var1);

    @GetMapping(value={"/api/user/certificateInfo/getByUserCodeAndType"})
    public Response<UserCertificateInfo> getUserCertificateInfoByUserCodeAndType(@RequestParam(value="userCode") String var1, @RequestParam(value="certificateType") String var2);

    @GetMapping(value={"/api/user/certificateInfo/getByUserCodeAndNotType"})
    public Response<List<UserCertificateInfo>> getUserCertificateInfoByUserCodeAndNotType(@RequestParam(value="userCode") String var1, @RequestParam(value="certificateType") String var2);

    @PostMapping(value={"/api/user/certificateInfo/deleteByUserCode/{userCode}"})
    public Response deleteUserCertificateInfoByUserCode(@PathVariable(value="userCode") String var1);

    @PostMapping(value={"/api/user/certificateInfo/deleteById/{id}"})
    public Response deleteUserCertificateInfoById(@PathVariable(value="id") Integer var1);

    @PostMapping(value={"/api/user/driveringLicenceInfo/saveOrUpdateUserDriveringLicenceInfo"})
    public Response saveOrUpdateUserDriveringLicenceInfo(@RequestBody UserDriveringLicenceInfo var1);

    @GetMapping(value={"/api/user/driveringLicenceInfo/{id}"})
    public Response<UserDriveringLicenceInfo> getUserDriveringLicenceInfoById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/user/driveringLicenceInfo/getByUserCode/{userCode}"})
    public Response<List<UserDriveringLicenceInfo>> getUserDriveringLicenceInfoByUserCode(@PathVariable(value="userCode") String var1);

    @PostMapping(value={"/api/user/driveringLicenceInfo/deleteByUserCode/{userCode}"})
    public Response deleteUserDriveringLicenceInfoByUserCode(@PathVariable(value="userCode") String var1);

    @PostMapping(value={"/api/user/driveringLicenceInfo/deleteById/{id}"})
    public Response deleteUserDriveringLicenceInfoById(@PathVariable(value="id") Integer var1);

    @PostMapping(value={"/api/user/driverLicenceInfo/saveOrUpdateUserDriverLicenceInfo"})
    public Response saveOrUpdateUserDriverLicenceInfo(@RequestBody UserDriverLicenceInfo var1);

    @GetMapping(value={"/api/user/driverLicenceInfo/{id}"})
    public Response<UserDriverLicenceInfo> getUserDriverLicenceInfoById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/user/driverLicenceInfo/getByUserCode/{userCode}"})
    public Response<UserDriverLicenceInfo> getUserDriverLicenceInfoByUserCode(@PathVariable(value="userCode") String var1);

    @PostMapping(value={"/api/user/driverLicenceInfo/deleteByUserCode/{userCode}"})
    public Response deleteUserDriverLicenceInfoByUserCode(@PathVariable(value="userCode") String var1);

    @PostMapping(value={"/api/user/driverLicenceInfo/deleteById/{id}"})
    public Response deleteUserDriverLicenceInfoById(@PathVariable(value="id") Integer var1);

    @PostMapping(value={"/api/user/user-car-information"})
    public Response saveOrUpdateUserCarInformation(@RequestBody UserCarInformation var1);

    @GetMapping(value={"/api/user/user-car-information/findUserCarInfomation"})
    public Response<List<UserCarInformation>> findUserCarInfomation(@RequestParam(name="code") String var1);

    @PostMapping(value={"/api/user/user-car-information/deleteMyCarInfor"})
    public Response deleteMyCarInfor(@RequestParam(name="code") String var1, @RequestParam(name="userCode") String var2);

    @GetMapping(value={"/api/user/recommend-code-scanning-record/getLatestByWxOpenid"})
    public Response<RecommendCodeScanningRecord> getLatestRecommendCodeScanningRecordByWxOpenid(@RequestParam(value="openid") String var1);

    @PostMapping(value={"/api/user/recommend-code-scanning-record"})
    public Response saveOrUpdateRecommendCodeScanningRecord(@RequestBody RecommendCodeScanningRecord var1);

    @PostMapping(value={"/api/user/recommend-code-scanning-record/updateMobileByUserCode"})
    public Response updateMobileOfRecommendCodeScanningRecordByUserCode(@RequestBody RecommendCodeScanningRecord var1);

    @PostMapping(value={"/api/user/recommend-code-scanning-record/updateLatestByWxOpenid"})
    public Response updateLatestRecommendCodeScanningRecordByWxOpenid(@RequestBody RecommendCodeScanningRecord var1);

    @GetMapping(value={"/api/user/recommend-code-scanning-record/pageQuery"})
    public PageTable<RecommendCodeScanningRecord> pageQueryRecommendCodeScanningRecord(@RequestParam(value="userCode", required=false) String var1, @RequestParam(value="openid", required=false) String var2, @RequestParam(value="mobile", required=false) String var3, @RequestParam(value="recommendCode", required=false) String var4, @RequestParam(value="startTime", required=false) String var5, @RequestParam(value="endTime", required=false) String var6, @RequestParam(value="page", defaultValue="1") Integer var7, @RequestParam(value="limit", defaultValue="20") Integer var8);

    @GetMapping(value={"/api/user/recommend-code-scanning-record/checkHasScanningRecord"})
    public Response<Boolean> checkHasRecommendCodeScanningRecord(@RequestParam(value="recommendCode") String var1);

    @PostMapping(value={"/api/user/msg/saveUserMsg"})
    public Response saveUserMsg(@RequestBody UserMsg var1);

    @GetMapping(value={"/api/user/msg/listUserMsg/{userCode}"})
    public Response<List<UserMsg>> findUserMsgList(@PathVariable(value="userCode") String var1);

    @GetMapping(value={"/api/user/msg/pageUserMsgList/{userCode}"})
    public PageTable<UserMsg> pageUserMsgList(@PathVariable(value="userCode") String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/user/msg/readUserMsgByCode/{code}"})
    public Response<UserMsg> readUserMsgByCode(@PathVariable(value="code") String var1);

    @GetMapping(value={"/api/user/msg/emptyUserMsgByUserCode/{userCode}"})
    public Response emptyUserMsgByUserCode(@PathVariable(value="userCode") String var1, @RequestParam(value="msgType", required=false) String var2);

    @GetMapping(value={"/api/user/msg/pageWebQueryPageUserMsg"})
    public PageTable<UserMsgWebDto> pageWebQueryPageUserMsg(@RequestParam(value="userCode", required=false) String var1, @RequestParam(value="code", required=false) String var2, @RequestParam(value="senderCode", required=false) String var3, @RequestParam(value="bindMobile", required=false) String var4, @RequestParam(value="msgType", required=false) String var5, @RequestParam(value="hasRead", required=false) Integer var6, @RequestParam(value="delStatus", required=false) Integer var7, @RequestParam(value="startTime", required=false) String var8, @RequestParam(value="endTime", required=false) String var9, @RequestParam(value="page", defaultValue="1") Integer var10, @RequestParam(value="limit", defaultValue="20") Integer var11);
}

