package com.rocogz.syy.user.constant;

/**
 * <dl>
 * <dd>Description: 用户中心服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/22 17:03</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class UserConstant {
    private UserConstant(){}

    /**
     * 字典值
     */
    public class DictData {
        private DictData(){}
        public static final String CAR_OWNER_USER_STATUS_NORMAL_CODE = "NORMAL";
        public static final String CAR_OWNER_IDENTIFY_TYPE_OPENID_CODE = "OPENID";
        public static final String CAR_OWNER_IDENTIFY_TYPE_MOBILE_CODE = "MOBILE";

        /** 证件类型编码-身份证 */
        public static final String CERTIFICATE_TYPE_ID_CODE = "01";

        /** 通用的是 */
        public static final String COMMON_YES = "Y";
        /** 通用的否 */
        public static final String COMMON_NO = "N";
    }

    /**
     * 用户车辆信息
     */
    public class CarInformation {
        private CarInformation(){}
        public static final String CAR_INFO_SOURCE_AUTO = "AUTO";//车辆信息来源-手动添加
        public static final String CAR_INFO_SOURCE_MANUAL = "MANUAL";//车辆信息来源-自动添加
        public static final String CAR_INFO_STATUS_NOT_CERTIFIED = "NOT_CERTIFIED";//车辆状态-未认证
    }
}
