package com.rocogz.syy.user.entity.identity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户中心-用户身份
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("user_identity")
public class UserIdentity extends IdEntity {

    private static final long serialVersionUID = -8267497017345338789L;
    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 用户openid
     */
    private String userWxOpenid;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 身份来源(CAR_OWNER:车服; OIL:油卡;PICC:人保)
     */
    private String identitySource;

    /**
     * 身份类型编码
     */
    private String identityTypeCode;

    /**
     * 身份编码
     */
    private String identityCode;

    /**
     * 状态
     */
    private String status;

    /**
     * 图标url
     */
    private String iconUrl;

    /**
     * 备注
     */
    private String remark;

    /**
     * 生效时间
     */
    private LocalDateTime effectiveTime;

    /**
     * 失效时间
     */
    private LocalDateTime expirationTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;


}
