package com.rocogz.syy.user.constant;

/**
 * <dl>
 * <dd>Description: 用户中心服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/22 17:03</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class UserConstant {
    private UserConstant(){}

    /**
     * 字典值
     */
    public class DictData {
        private DictData(){}
        public static final String CAR_OWNER_USER_STATUS_NORMAL_CODE = "NORMAL";
        public static final String CAR_OWNER_IDENTIFY_TYPE_OPENID_CODE = "OPENID";
        public static final String CAR_OWNER_IDENTIFY_TYPE_MOBILE_CODE = "MOBILE";

        /** 证件类型编码-身份证 */
        public static final String CERTIFICATE_TYPE_ID_CODE = "01";

        /** 通用的是 */
        public static final String COMMON_YES = "Y";
        /** 通用的否 */
        public static final String COMMON_NO = "N";
        public static final String USER_IDENTITY_AGENT_CODE = "AGENT";
    }

    /**
     * 用户车辆信息
     */
    public static class CarInformation {
        private CarInformation(){}
        public static final String CAR_INFO_SOURCE_AUTO = "AUTO";//车辆信息来源-手动添加
        public static final String CAR_INFO_SOURCE_MANUAL = "MANUAL";//车辆信息来源-自动添加
        public static final String CAR_INFO_STATUS_NOT_CERTIFIED = "NOT_CERTIFIED";//车辆状态-未认证
    }

    /**
     * 用户身份来源
     */
    public static class UserIdentitySource {
        private UserIdentitySource(){}
        public static final String TYPE_CODE = "USER_IDENTITY_SOURCE";
        public static final String CAR_OWNER = "CAR_OWNER";
    }

    /**
     * 用户身份状态
     */
    public static class UserIdentityStatus {
        private UserIdentityStatus(){}
        public static final String TYPE_CODE = "USER_IDENTITY_STATUS";
        public static final String NORMAL = "NORMAL";
        public static final String EXPIRATION = "EXPIRATION";
        public static final String LOCK = "LOCK";
    }

    /**
     * 用户代理人身份认证状态
     */
    public static class UserIdentityAuthStatus {
        private UserIdentityAuthStatus(){}
        public static final String TYPE_CODE = "USER_IDENTITY_AUTH_STATUS";
        /** 待审核 */
        public static final String PENDING_APPROVE = "PENDING_APPROVE";
        /** 审核不通过 */
        public static final String REFUSE = "REFUSE";
        /** 审核通过 */
        public static final String PASS = "PASS";
    }

    /**
     * 用户代理人身份认证方式
     */
    public static class UserIdentityAuthWay {
        private UserIdentityAuthWay(){}
        public static final String TYPE_CODE = "USER_IDENTITY_AUTH_WAY";
        /** 保险从业人员-资格证书 */
        public static final String QUALIFICATION = "QUALIFICATION";
        /** 保险从业人员-省份证尾号 */
        public static final String QUALIFICATION_ID_LAST = "QUALIFICATION_ID_LAST";
        /** 保险公司人员 */
        public static final String COMPANY = "COMPANY";
        /** 其他人员 */
        public static final String OTHER = "OTHER";
        /** 企业商户 */
        public static final String COMPANY_STORE = "COMPANY_STORE";
    }

    /**
     * 用户来源
     */
    public static class UserSource {
        private UserSource() {
        }

        public static final String TYPE_CODE = "USER_SOURCE";
        /**
         * 车主端
         */
        public static final String CAR_OWNER = "CAR_OWNER";
        /**
         * ROCO特惠商城
         */
        public static final String ROCO_MALL = "ROCO_MALL";
    }

}
