package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户中心-用户基本信息
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-09
 */
@TableName("user_basic_info")
@ApiModel("用户基本信息")
@Data
public class UserBasicInfo extends IdEntity {

    private static final long serialVersionUID = -1362630806045543055L;
    /**
     * 用户编号
     */
    @ApiModelProperty("用户编号")
    private String code;

    /**
     * 绑定手机号
     */
    @ApiModelProperty("绑定手机号")
    private String bindMobile;

    /**
     * 生日
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("生日")
    private LocalDate birthday;

    /**
     * 状态(NORMAL:正常;LOCK:锁定;CANCEL:注销;)
     */
    @ApiModelProperty("状态(NORMAL:正常;LOCK:锁定;CANCEL:注销;)")
    private String status;

    /**
     * 用户来源(CAR_OWNER:车主端;ROCO_MALL:ROCO特惠商城)
     */
    @ApiModelProperty("用户来源(CAR_OWNER:车主端;ROCO_MALL:ROCO特惠商城)")
    private String source;

    /**
     * openid
     */
    @ApiModelProperty("openid")
    private String wxOpenid;

    /**
     * 微信昵称
     */
    @ApiModelProperty("微信昵称")
    private String wxNickName;

    /**
     * 微信头像url
     */
    @ApiModelProperty("微信头像url")
    private String wxAvatarUrl;

    /**
     * 微信用户性别
     */
    @ApiModelProperty("微信用户性别")
    private Integer wxGender;

    /**
     * 注册时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("注册时间")
    private LocalDateTime registerTime;

    /**
     * 小程序appid.
     */
    @ApiModelProperty("小程序appid")
    private String miniAppid;

    /**
     * 小程序名称.
     */
    @ApiModelProperty("小程序appid")
    @TableField(exist = false)
    private String miniAppName;

    /**
     * 所属服务平台名称.
     */
    @ApiModelProperty("所属服务平台名称")
    @TableField(exist = false)
    private String servicePlatformName;
}
