package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户中心-用户店铺收藏关联表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-14
 */
@TableName("user_store_collection")
@Data
@ApiModel("用户店铺收藏信息表")
public class UserStoreCollection extends IdEntity {

    private static final long serialVersionUID = 4961775039948591391L;
    /**
     * 用户编号
     */
    @ApiModelProperty("用户编码")
    private String userCode;

    /**
     * 商户编码
     */
    @ApiModelProperty("商户编码")
    private String storeCode;

    /**
     * 收藏时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("收藏时间")
    private LocalDateTime collectionTime;

    /**
     * 收藏类型
     */
    @ApiModelProperty("收藏类型")
    private String type;
}
