package com.rocogz.syy.user.entity.popularize;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 推广信息表
 * </p>
 *
 * @author luoyc
 * @since 2020-10-28
 */
@Data
@Accessors(chain = true)
@TableName("user_popularize_info")
public class UserPopularizeInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 信息编号
     */
    private String code;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 用户姓名
     */
    private String userName;

    /**
     * 用户手机号
     */
    private String mobile;

    /**
     * 推荐码
     */
    private String iiuvCode;

    /**
     * 推广码
     */
    private String popularizeCode;

    /**
     * 推广等级
     */
    private String popularizeGrade;

    /**
     * 奖励比例
     */
    private BigDecimal rewardRatio;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;


}
