package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户中心-用户认证信息
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-09
 */
@TableName("user_authentication_info")
@ApiModel("用户认证信息")
@Data
@EqualsAndHashCode(callSuper = false)
public class UserAuthenticationInfo extends IdEntity {

    private static final long serialVersionUID = 7112742278744825404L;
    /**
     * 用户编号
     */
    @ApiModelProperty("用户编号")
    private String userCode;

    /**
     * 认证手机号
     */
    @ApiModelProperty("认证手机号")
    private String caMobile;

    /**
     * 手机号认证时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("手机号认证时间")
    private LocalDateTime caMobileTime;

    /**
     * 认证证件类型
     */
    @ApiModelProperty("认证证件类型")
    private String caIdType;

    /**
     * 认证证件号码
     */
    @ApiModelProperty("认证证件号码")
    private String caIdCard;

    /**
     * 证件认证时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("证件认证时间")
    private LocalDateTime caIdTime;

    /**
     * 证件认证姓名
     */
    @ApiModelProperty("证件认证姓名")
    private String caIdName;

    /**
     * 认证邮箱
     */
    @ApiModelProperty("认证邮箱")
    private String caEmail;

    /**
     * 邮箱认证时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("邮箱认证时间")
    private LocalDateTime caEmailTime;
}
