package com.rocogz.syy.user.entity.agent;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.user.entity.UserBasicInfo;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 代理人中心我的邀请
 * </p>
 *
 * @author liangyongtong
 * @since 2020-10-14
 */
@Data
@Accessors(chain = true)
@TableName("user_agent_invite")
public class UserAgentInvite extends IdEntity {

    private static final long serialVersionUID = 6726087068804594573L;
    /**
     * 推荐码
     */
    private String iiuvCode;

    /**
     * 邀请人用户编码
     */
    private String userCode;

    /**
     * 邀请数
     */
    @TableField(exist = false)
    private Integer inviteCount;

    /**
     * 已认证数
     */
    @TableField(exist = false)
    private Integer identification;

    /**
     * 邀请人openid
     */
    private String openid;

    /**
     * 邀请人手机号
     */
    private String mobile;

    /**
     * 邀请人信息
     */
    @TableField(exist = false)
    private UserBasicInfo userInfo;

    /**
     * 被邀请人用户编码
     */
    private String beInvitedUserCode;

    /**
     * 被邀请人openid
     */
    private String beInvitedOpenid;

    /**
     * 被邀请人手机号
     */
    private String beInvitedMobile;

    /**
     * 被邀请人姓名
     */
    @TableField(exist = false)
    private String beInviteName;

    /**
     * 被邀请人信息
     */
    @TableField(exist = false)
    private UserBasicInfo beInviteUserInfo;

    /**
     * 被邀请人性质:注册、认证、有效
     */
    private String nature;

    /**
     * 注册时间
     */
    private LocalDateTime registerTime;

    /**
     * 首次成功交易时间：有效时间
     */
    private LocalDateTime validTime;

    /**
     * 认证时间:审批时间
     */
    private LocalDateTime identificationTime;

}
