package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户中心-小程序推荐码扫描记录
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-05-28
 */
@TableName("user_recommend_code_scanning_record")
@Data
public class RecommendCodeScanningRecord extends IdEntity {

    private static final long serialVersionUID = 7120810421341789001L;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 注册手机号
     */
    private String registerMobile;

    /**
     * 注册时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    private LocalDateTime registerTime;

    /**
     * 扫码时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    private LocalDateTime scanningTime;

    /**
     * 注册微信openid
     */
    private String wxOpenid;

    /**
     * 注册微信昵称
     */
    private String wxNickName;

    /**
     * 微信头像url
     */
    private String wxAvatarUrl;

    /**
     * 推荐码
     */
    private String recommendCode;

    /**
     * 类型(QR_CODE: 二维码扫描; SHARE: 分享)
     */
    private String type;
}
