package com.rocogz.syy.user.dto.issuingbody;

import com.rocogz.syy.user.entity.UserRegisterInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDate;

/**
 * The type User issuing body customer detail dto.
 * @author huangdeyi
 */
@Data
@Accessors(chain = true)
@ApiModel("发放主体客户详情")
public class UserIssuingBodyCustomerDetailDto {

    @ApiModelProperty(value="客户编号")
    private String code;

    @ApiModelProperty(value="客户名称")
    private String name;

    @ApiModelProperty(value="手机号")
    private String mobile;

    @ApiModelProperty(value="微信性别")
    private String wxGender;

    @ApiModelProperty(value="生日")
    private LocalDate birthday;

    @ApiModelProperty(value="微信头像")
    private String wxNickName;

    @ApiModelProperty(value="微信昵称")
    private String wxAvatarUrl;

    @ApiModelProperty(value="微信openid")
    private String wxOpenid;

    @ApiModelProperty(value = "小程序appid")
    private String miniAppid;

    @ApiModelProperty(value = "所属平台")
    private String platform;

    @ApiModelProperty(value = "所属平台编号")
    private String platformCode;

    @ApiModelProperty(value="用户来源")
    private String userSource;

    @ApiModelProperty(value="用户编号")
    private String userCode;

    @ApiModelProperty(value="用户状态")
    private String userStatus;

    @ApiModelProperty(value="主体编号")
    private String issuingBodyCode;

    @ApiModelProperty("主体简称")
    private String issuingBodyAbbreviation;

    @ApiModelProperty("主体名称")
    private String issuingBodyName;

    @ApiModelProperty("用户注册信息")
    private UserRegisterInfo userRegisterInfo;
}
