package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户中心-用户注册信息
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-09
 */
@EqualsAndHashCode(callSuper = true)
@TableName("user_register_info")
@ApiModel("用户注册信息")
@Data
public class UserRegisterInfo extends IdEntity {

    private static final long serialVersionUID = -6723428424674493633L;
    /**
     * 用户编号
     */
    @ApiModelProperty("用户编号")
    private String userCode;

    /**
     * 注册手机号
     */
    @ApiModelProperty("注册手机号")
    private String registerMobile;

    /**
     * 注册日期
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("注册日期")
    private LocalDate registerDate;

    /**
     * 注册时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("注册时间")
    private LocalDateTime registerTime;

    /**
     * 注册微信openid
     */
    @ApiModelProperty("注册微信openid")
    private String registerWxOpenid;

    /**
     * 注册微信昵称
     */
    @ApiModelProperty("注册微信昵称")
    private String registerWxNickName;

    /**
     * 注册城市
     */
    @ApiModelProperty("注册城市")
    private String registerCity;

    /**
     * 注册ip
     */
    @ApiModelProperty("注册ip")
    private String registerIp;

    /**
     * 推荐码
     */
    @ApiModelProperty("推荐码")
    private String recommendCode;
}
