package com.rocogz.syy.user.dto.info;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * @Description: 用户手机解绑req dto
 * @date：2021/9/26
 * @author：huangdeyi
 */
@Data
public class UserMobileUnbindReqDto {

    /**
     * 用户code
     */
    @NotBlank(message = "用户code不能为空")
    private String userCode;

    /**
     * 微信昵称
     */
    private String wxNickName;

    /**
     * 微信openid
     */
    @NotBlank(message = "微信openid不能为空")
    private String wxOpenid;

    /**
     * 所属小程序appid.
     */
    private String miniAppid;

    /**
     * 小程序名称.
     */
    private String miniAppName;

    /**
     * 解绑/绑定手机号
     */
    @NotBlank(message = "解绑/绑定手机号")
    private String mobile;

    /**
     * 操作时间
     */
    private LocalDateTime operationTime;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 操作人手机号
     */
    private String operatorMobile;
}
