/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.user.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.user.dto.UserFullInfoDto;
import com.rocogz.syy.user.entity.UserAuthenticationInfo;
import com.rocogz.syy.user.entity.UserBasicInfo;
import com.rocogz.syy.user.entity.UserLoginCredentials;
import com.rocogz.syy.user.entity.UserLoginLog;
import com.rocogz.syy.user.entity.UserRegisterInfo;
import com.rocogz.syy.user.entity.UserStoreCollection;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IUserClientService {
    @PostMapping(value={"/api/user/user-authentication-info"})
    public Response saveOrUpdateUserAuthenticationInfo(@RequestBody UserAuthenticationInfo var1);

    @PostMapping(value={"/api/user/user-authentication-info/updateByUserCode"})
    public Response updateUserAuthenticationInfoByUserCode(@RequestBody UserAuthenticationInfo var1);

    @GetMapping(value={"/api/user/user-authentication-info/getByUserCode"})
    public Response<UserAuthenticationInfo> getUserAuthenticationInfoByUserCode(@RequestParam(value="userCode") String var1);

    @GetMapping(value={"/api/user/user-authentication-info/getByMobile"})
    public Response<UserAuthenticationInfo> getUserAuthenticationInfoByMobile(@RequestParam(value="mobile") String var1);

    @GetMapping(value={"/api/user/user-authentication-info/getByEmail"})
    public Response<UserAuthenticationInfo> getUserAuthenticationInfoByEmail(@RequestParam(value="email") String var1);

    @GetMapping(value={"/api/user/user-authentication-info/getByIdTypeAndCard"})
    public Response<UserAuthenticationInfo> getUserAuthenticationInfoByIdTypeAndCard(@RequestParam(value="idType") String var1, @RequestParam(value="idCard") String var2);

    @PostMapping(value={"/api/user/user-basic-info"})
    public Response<UserBasicInfo> saveOrUpdateUserBasicInfo(@RequestBody UserBasicInfo var1);

    @PostMapping(value={"/api/user/user-basic-info/updateByUserCode"})
    public Response updateUserBasicInfoByUserCode(@RequestBody UserBasicInfo var1);

    @GetMapping(value={"/api/user/user-basic-info/getByOpenid"})
    public Response<UserBasicInfo> getUserBasicInfoByOpenid(@RequestParam(value="openid") String var1);

    @GetMapping(value={"/api/user/user-basic-info/getByUserCode"})
    public Response<UserBasicInfo> getUserBasicInfoByUserCode(@RequestParam(value="userCode") String var1);

    @GetMapping(value={"/api/user/user-basic-info/getByUserCodeList"})
    public Response<List<UserBasicInfo>> getUserBasicInfoByUserCodeList(@NotNull @NotEmpty @RequestParam(value="userCodeList") List<String> var1);

    @GetMapping(value={"/api/user/user-basic-info/pageQuery"})
    public PageTable<UserBasicInfo> pageQueryUserBasicInfo(@RequestParam(value="userCode", required=false) String var1, @RequestParam(value="openid", required=false) String var2, @RequestParam(value="wxName", required=false) String var3, @RequestParam(value="mobile", required=false) String var4, @RequestParam(value="status", required=false) String var5, @RequestParam(value="startTime", required=false) String var6, @RequestParam(value="endTime", required=false) String var7, @RequestParam(value="page", defaultValue="1") Integer var8, @RequestParam(value="limit", defaultValue="20") Integer var9);

    @PostMapping(value={"/api/user/user-login-credentials"})
    public Response saveOrUpdateUserLoginCredentials(@RequestBody UserLoginCredentials var1);

    @PostMapping(value={"/api/user/user-login-credentials/updateByUserCode"})
    public Response updateUserLoginCredentialsByUserCode(@RequestBody UserLoginCredentials var1);

    @GetMapping(value={"/api/user/user-login-credentials/getByCredentials"})
    public Response<UserLoginCredentials> getUserLoginCredentialsByCredentials(@RequestParam(value="credentials") String var1, @RequestParam(value="type") String var2);

    @GetMapping(value={"/api/user/user-login-credentials/getByUserCode"})
    public Response<UserLoginCredentials> getUserLoginCredentialsByUserCode(@RequestParam(value="userCode") String var1);

    @PostMapping(value={"/api/user/user-register-info"})
    public Response saveOrUpdateUserRegisterInfo(@RequestBody UserRegisterInfo var1);

    @PostMapping(value={"/api/user/user-register-info/updateByUserCode"})
    public Response updateUserRegisterInfoByUserCode(@RequestBody UserRegisterInfo var1);

    @GetMapping(value={"/api/user/user-register-info/getByOpenid"})
    public Response<UserRegisterInfo> getUserRegisterInfoByOpenid(@RequestParam(value="openid") String var1);

    @GetMapping(value={"/api/user/user-register-info/getByUserCode"})
    public Response<UserRegisterInfo> getUserRegisterInfoByUserCode(@RequestParam(value="userCode") String var1);

    @PostMapping(value={"/api/user/user-store-collection"})
    public Response saveUserStoreCollection(@RequestBody UserStoreCollection var1);

    @GetMapping(value={"/api/user/user-store-collection/list"})
    public Response<List<UserStoreCollection>> listUserStoreCollection(@RequestParam(value="userCode", required=false) String var1, @RequestParam(value="storeCode", required=false) String var2);

    @DeleteMapping(value={"/api/user/user-store-collection/batchDelete"})
    public Response batchDeleteUserStoreCollection(@NotEmpty @RequestParam(value="userCode") String var1, @NotNull @NotEmpty @RequestParam(value="storeCodeList") List<String> var2);

    @DeleteMapping(value={"/api/user/user-store-collection"})
    public Response deleteUserStoreCollectionById(@NotNull @RequestParam(value="id") Integer var1);

    @PostMapping(value={"/api/user/user-login-log"})
    public Response saveUserLoginLog(@RequestBody UserLoginLog var1);

    @GetMapping(value={"/api/user/user-login-log/pageQuery"})
    public PageTable<UserLoginLog> pageQueryUserLoginLog(@RequestParam(value="userCode", required=false) String var1, @RequestParam(value="openid", required=false) String var2, @RequestParam(value="startTime", required=false) String var3, @RequestParam(value="endTime", required=false) String var4, @RequestParam(value="page", defaultValue="1") Integer var5, @RequestParam(value="limit", defaultValue="20") Integer var6);

    @GetMapping(value={"/api/user/user-full-info/getUserBasicAndAuthenticationInfo"})
    public Response<UserFullInfoDto> getUserBasicAndAuthenticationInfo(@RequestParam(value="mobile") String var1);
}

