package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户中心-用户注册信息
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-09
 */
@TableName("user_register_info")
@ApiModel("用户注册信息")
public class UserRegisterInfo extends IdEntity {

    private static final long serialVersionUID = 2590188829817278481L;
    /**
     * 用户编号
     */
    @ApiModelProperty("用户编号")
    private String userCode;

    /**
     * 注册手机号
     */
    @ApiModelProperty("注册手机号")
    private String registerMobile;

    /**
     * 注册日期
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("注册日期")
    private LocalDate registerDate;

    /**
     * 注册时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("注册时间")
    private LocalDateTime registerTime;

    /**
     * 注册微信openid
     */
    @ApiModelProperty("注册微信openid")
    private String registerWxOpenid;

    /**
     * 注册微信昵称
     */
    @ApiModelProperty("注册微信昵称")
    private String registerWxNickName;

    /**
     * 注册城市
     */
    @ApiModelProperty("注册城市")
    private String registerCity;

    /**
     * 注册ip
     */
    @ApiModelProperty("注册ip")
    private String registerIp;

    /**
     * 推荐人
     */
    @ApiModelProperty("推荐人")
    private String referee;


    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getRegisterMobile() {
        return registerMobile;
    }

    public void setRegisterMobile(String registerMobile) {
        this.registerMobile = registerMobile;
    }

    public LocalDate getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(LocalDate registerDate) {
        this.registerDate = registerDate;
    }

    public LocalDateTime getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(LocalDateTime registerTime) {
        this.registerTime = registerTime;
    }

    public String getRegisterWxOpenid() {
        return registerWxOpenid;
    }

    public void setRegisterWxOpenid(String registerWxOpenid) {
        this.registerWxOpenid = registerWxOpenid;
    }

    public String getRegisterWxNickName() {
        return registerWxNickName;
    }

    public void setRegisterWxNickName(String registerWxNickName) {
        this.registerWxNickName = registerWxNickName;
    }

    public String getRegisterCity() {
        return registerCity;
    }

    public void setRegisterCity(String registerCity) {
        this.registerCity = registerCity;
    }

    public String getRegisterIp() {
        return registerIp;
    }

    public void setRegisterIp(String registerIp) {
        this.registerIp = registerIp;
    }

    public String getReferee() {
        return referee;
    }

    public void setReferee(String referee) {
        this.referee = referee;
    }

    @Override
    public String toString() {
        return "UserRegisterInfo{" +
        "userCode=" + userCode +
        ", registerMobile=" + registerMobile +
        ", registerDate=" + registerDate +
        ", registerTime=" + registerTime +
        ", registerWxOpenid=" + registerWxOpenid +
        ", registerWxNickName=" + registerWxNickName +
        ", registerCity=" + registerCity +
        ", registerIp=" + registerIp +
        ", referee=" + referee +
        "}";
    }
}
