package com.rocogz.syy.user.entity.certificate;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户驾驶证
 * </p>
 *
 * @author yinshihao
 * @since 2020-05-15
 */
@ApiModel
@Data
@TableName("user_driver_licence_info")
public class UserDriverLicenceInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户编号
     */
    @ApiModelProperty("用户编号")
    private String userCode;

    /**
     * 证号
     */
    @ApiModelProperty("证号")
    private String certificateNumber;

    /**
     * 用户姓名
     */
    @ApiModelProperty("用户姓名")
    private String name;

    /**
     * 准驾车型
     */
    @ApiModelProperty("准驾车型")
    private String driverCarType;

    /**
     * 档案编号
     */
    @ApiModelProperty("档案编号")
    private String fileNumber;

    /**
     * 正面图片地址
     */
    @ApiModelProperty("正面图片地址")
    private String frontImgPath;

    /**
     * 背面图片地址
     */
    @ApiModelProperty("背面图片地址")
    private String backImgPath;

    /**
     * 生效日期
     */
    @ApiModelProperty("生效日期")
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    private LocalDate beginEffective;

    /**
     * 失效日期
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("失效日期")
    private LocalDate endEffective;

    /**
     * 创建时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("更新时间")
    private LocalDateTime updateTime;
}
