package com.rocogz.syy.user.entity.certificate;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户行驶证
 * </p>
 *
 * @author yinshihao
 * @since 2020-05-15
 */
@ApiModel
@Data
@TableName("user_drivering_licence_info")
public class UserDriveringLicenceInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户编号
     */
    @ApiModelProperty("用户编号")
    private String userCode;

    /**
     * 用户姓名
     */
    @ApiModelProperty("用户姓名")
    private String name;

    /**
     * 车牌号
     */
    @ApiModelProperty("车牌号")
    private String carNumber;

    /**
     * 车辆类型
     */
    @ApiModelProperty("车辆类型")
    private String carType;

    /**
     * 车辆识别代号
     */
    @ApiModelProperty("车辆识别代号")
    private String carIdentifiyNumber;

    /**
     * 发动机代号
     */
    @ApiModelProperty("发动机代号")
    private String engineNumber;

    /**
     * 正面图片地址
     */
    @ApiModelProperty("正面图片地址")
    private String frontImgPath;

    /**
     * 背面图片地址
     */
    @ApiModelProperty("背面图片地址")
    private String backImgPath;

    /**
     * 生效日期
     */
    @ApiModelProperty("生效日期")
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    private LocalDate beginEffective;

    /**
     * 失效日期
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("失效日期")
    private LocalDate endEffective;

    /**
     * 创建时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("更新时间")
    private LocalDateTime updateTime;
}
