package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户车辆信息
 * </p>
 *
 * @author yifenrui
 * @since 2020-05-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("user_car_information")
@ApiModel("用户车辆信息")
public class UserCarInformation extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    @ApiModelProperty("车辆信息编号")
    private String code;

    /**
     * 用户编号
     */
    @ApiModelProperty("用户编号")
    private String userCode;

    /**
     * 车牌号
     */
    @ApiModelProperty("车牌号")
    private String carNumber;

    /**
     * 车辆类型字典code
     */
    @ApiModelProperty("车辆类型字典code")
    private String carTypeDictCode;

    /**
     * 车辆识别代号
     */
    private String carIdentifiyNumber;

    /**
     * 车辆识别代号后六位
     */
    @ApiModelProperty("车辆识别代号后六位")
    private String carIdentifiyNumberSix;

    /**
     * 发动机代号
     */
    private String engineNumber;

    /**
     * 发动机代号后六位
     */
    @ApiModelProperty("发动机代号后六位")
    private String engineNumberSix;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String status;

    /**
     * 创建时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("更新时间")
    private LocalDateTime updateTime;


    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    private String source;

    /**
     * 车辆性质
     */
    @ApiModelProperty("车辆性质")
    private String nature;

    /**
     * 是否删除(Y : 删除状态, N : 未删除状态)
     */
    @ApiModelProperty("是否删除")
    private String del;


    /**
     * 车辆类型name
     */
    @TableField(exist = false)
    private String carTypeDictName;


}
