package com.rocogz.syy.user.entity.issuingbody;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@ApiModel("发放主体客户")
@TableName("user_issuing_body_customer")
public class UserIssuingBodyCustomer extends IdEntity {

    private static final long serialVersionUID = 141240561806044313L;

    /**
    * 客户编号
    */
    @ApiModelProperty(value="客户编号")
    private String code;
    
    /**
    * 客户姓名
    */
    @ApiModelProperty(value="客户姓名")
    private String name;
    
    /**
    * 发放主体编号
    */
    @ApiModelProperty(value="发放主体编号")
    private String issuingBodyCode;
    
    /**
    * 用户编号
    */
    @ApiModelProperty(value="用户编号")
    private String userCode;
    
    /**
    * 用户微信openid
    */
    @ApiModelProperty(value="用户微信openid")
    private String userWxOpenid;
    
    /**
    * 客户注册时间
    */
    @ApiModelProperty(value="客户注册时间")
    private LocalDateTime customerRegisterTime;
}