package com.rocogz.syy.weixin.pay.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * <dl>
 * <dd>Description: WxPayProperties</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/6/9 15:06</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@ConfigurationProperties(prefix = "wx.pay")
public class WxPayProperties {

    /**
     * 是否使用沙箱环境, 默认false.
     */
    private boolean useSandboxEnv = false;

    /**
     * 设置微信公众号或者小程序等的appid.
     */
    private String appId;

    /**
     * 微信支付商户号.
     */
    private String mchId;

    /**
     * 微信支付商户密钥.
     */
    private String mchKey;

    /**
     * 服务商模式下的子商户公众账号ID，普通模式请不要配置，请在配置文件中将对应项删除.
     */
    private String subAppId;

    /**
     * 服务商模式下的子商户号，普通模式请不要配置，最好是请在配置文件中将对应项删除.
     */
    private String subMchId;

    /**
     * apiclient_cert.p12文件的绝对路径，或者如果放在项目中，请以classpath:开头指定.
     */
    private String keyPath;

    /**
     * 交易类型.
     * JSAPI--公众号支付、NATIVE--原生扫码支付、APP--app支付
     */
    private String tradeType;

    /**
     * 支付成功回调地址，不可携带参数.
     */
    private String notifyUrl;

//    以下是apiv3以及支付分相关(3.8新增)

//    /**
//     * 微信支付分serviceId
//     */
//    private String serviceId;
//
//    /**
//     * 证书序列号
//     */
//    private String certSerialNo;
//
//    /**
//     * apiV3秘钥
//     */
//    private String apiv3Key;
//
//    /**
//     * 微信支付分回调地址
//     */
//    private String payScoreNotifyUrl;
//
//    /**
//     * apiv3 商户apiclient_key.pem
//     */
//    private String privateKeyPath;
//
//    /**
//     * apiv3 商户apiclient_cert.pem
//     */
//    private String privateCertPath;

}
