package com.rocogz.syy.weixin.pay.config;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * <pre>
 *  微信支付自动配置
 *  Created by BinaryWang on 2019/4/17.
 * </pre>
 *
 * @author <a href="https://github.com/binarywang">Binary Wang</a>
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(WxPayProperties.class)
@ConditionalOnClass(WxPayServiceHolder.class)
@ConditionalOnProperty(prefix = "wx.pay", value = "enabled", matchIfMissing = true)
public class WxPayAutoConfiguration {

    @Autowired
    private WxPayProperties properties;

    /**
     * 构造微信支付服务对象.
     *
     * @return 微信支付service
     */
    @Bean
    @ConditionalOnMissingBean(WxPayServiceHolder.class)
    public WxPayServiceHolder wxPayService() {
        log.info("初始化微信支付配置信息开始");
        final WxPayServiceHolder holder = new WxPayServiceHolder();
        for (WxPayProperties.Config config : properties.getConfigList()) {
            final WxPayServiceImpl wxPayService = new WxPayServiceImpl();
            WxPayConfig payConfig = new WxPayConfig();
            payConfig.setAppId(StringUtils.trimToNull(config.getAppId()));
            payConfig.setMchId(StringUtils.trimToNull(config.getMchId()));
            payConfig.setMchKey(StringUtils.trimToNull(config.getMchKey()));
            payConfig.setSubAppId(StringUtils.trimToNull(config.getSubAppId()));
            payConfig.setSubMchId(StringUtils.trimToNull(config.getSubMchId()));
            payConfig.setKeyPath(StringUtils.trimToNull(config.getKeyPath()));
            payConfig.setTradeType(StringUtils.trimToNull(config.getTradeType()));
            payConfig.setNotifyUrl(StringUtils.trimToNull(config.getNotifyUrl()));
            // 以下是apiv3以及支付分相关(3.8新增)
//        payConfig.setServiceId(StringUtils.trimToNull(config.getServiceId()));
//        payConfig.setPayScoreNotifyUrl(StringUtils.trimToNull(config.getPayScoreNotifyUrl()));
//        payConfig.setPrivateKeyPath(StringUtils.trimToNull(config.getPrivateKeyPath()));
//        payConfig.setPrivateCertPath(StringUtils.trimToNull(config.getPrivateCertPath()));
//        payConfig.setCertSerialNo(StringUtils.trimToNull(config.getCertSerialNo()));
//        payConfig.setApiV3Key(StringUtils.trimToNull(config.getApiv3Key()));

            // 是否沙箱环境运行
            payConfig.setUseSandboxEnv(config.isUseSandboxEnv());
            wxPayService.setConfig(payConfig);
            holder.getWxPayServiceMap().put(config.getAppId(), wxPayService);
            holder.getDefaultRefundNotifyUrlMap().put(config.getAppId(), config.getRefundNotifyUrl());
        }
        log.info("初始化微信支付配置信息结束");
        return holder;
    }

}