/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.aop.logger.principal;

import com.rocoinfo.aop.logger.entity.Principal;
import com.rocoinfo.aop.logger.principal.PrincipalHandler;
import com.rocoinfo.aop.logger.principal.ServletRequestPrincipalHandler;
import javax.servlet.ServletRequest;

public class PrincipalHandlerHelper {
    public PrincipalHandler principalHandler;
    public ServletRequestPrincipalHandler servletRequestPrincipalHandler;

    private PrincipalHandlerHelper(PrincipalHandler principalHandler) {
        this.principalHandler = principalHandler;
    }

    private PrincipalHandlerHelper(ServletRequestPrincipalHandler servletRequestPrincipalHandler) {
        this.servletRequestPrincipalHandler = servletRequestPrincipalHandler;
    }

    public static PrincipalHandlerHelper getInstance(PrincipalHandler principalHandler) {
        return new PrincipalHandlerHelper(principalHandler);
    }

    public static PrincipalHandlerHelper getInstance(ServletRequestPrincipalHandler servletRequestPrincipalHandler) {
        return new PrincipalHandlerHelper(servletRequestPrincipalHandler);
    }

    public Principal getPrincipal(ServletRequest request) {
        if (this.principalHandler != null) {
            return this.principalHandler.getPrincipal();
        }
        if (this.servletRequestPrincipalHandler != null) {
            return this.servletRequestPrincipalHandler.getPrincipal(request);
        }
        return null;
    }

    public String getUsername(ServletRequest request) {
        Principal principal = this.getPrincipal(request);
        return principal == null ? "" : principal.getUsername();
    }
}

