package com.rocoinfo.aop.logger.container;

import org.springframework.util.StringUtils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/6/30 下午4:15</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class BeanContainer {

    private static final Map<String, Object> container = new ConcurrentHashMap<>();

    public static void registerBean(String beanName, String beanClassName) {
        if (StringUtils.isEmpty(beanName)) {
            return;
        }
        Object o = generateBeanObject(beanClassName);
        if (o != null) {
            container.put(beanName, beanClassName);
        }
    }

    public static void addBean(String beanName, BeanHandler handler) {
        if (StringUtils.isEmpty(beanName)) {
            return;
        }
        Object o = handler.get();
        if (o == null) {
            return;
        }
        container.put(beanName, o);
    }

    public static Object get(String beanName) {
        return container.get(beanName);
    }

    public static <T> T getBean(String beanName, Class<T> clazz) {
        Object o = container.get(beanName);
        if (o != null) {
            return (T) o;
        }
        return null;
    }

    private static Object generateBeanObject(String beanClassName) {
        try {
            return Class.forName(beanClassName).newInstance();
        } catch (InstantiationException | IllegalAccessException | ClassNotFoundException e) {
            return null;
        }
    }

    public interface BeanHandler {
        Object get();
    }
}
