package com.rocoinfo.aop.logger.entity;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/6/8 上午10:30</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class LoggerEntity {

    /**
     * app
     */
    private String app;

    /**
     * 请求模块
     */
    private String module;

    /**
     * 请求的ip
     */
    private String ip;

    /**
     * 请求的url
     */
    private String url;

    /**
     * 调用时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date date;

    /**
     * 请求方式
     */
    private String requestMethod;

    /**
     * 方法签名
     */
    private String methodignature;

    /**
     * 请求参数
     */
    private Map<String, Object> params;

    /**
     * 当前登录的用户名
     */
    private String username;

    /**
     * 浏览器类型
     */
    private String browserType;

    /**
     * 是否成功
     */
    private Boolean success;

    /**
     * 错误信息
     */
    private String message;


    /**
     * 返回结果
     */
    private Object result;

    /**
     * 执行时间
     */
    private long execTime;

    public String getRequestMethod() {
        return requestMethod;
    }

    public LoggerEntity setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public String getModule() {
        return module;
    }

    public LoggerEntity setModule(String module) {
        this.module = module;
        return this;
    }

    public String getIp() {
        return ip;
    }

    public LoggerEntity setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public LoggerEntity setUrl(String url) {
        this.url = url;
        return this;
    }

    public Date getDate() {
        return date;
    }

    public LoggerEntity setDate(Date date) {
        this.date = date;
        return this;
    }


    public String getMethodignature() {
        return methodignature;
    }

    public LoggerEntity setMethodignature(String methodignature) {
        this.methodignature = methodignature;
        return this;
    }

    public Map<String, Object> getParams() {
        return params;
    }

    public LoggerEntity setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public String getUsername() {
        return username;
    }

    public LoggerEntity setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getBrowserType() {
        return browserType;
    }

    public LoggerEntity setBrowserType(String browserType) {
        this.browserType = browserType;
        return this;
    }

    public Boolean getSuccess() {
        return success;
    }

    public LoggerEntity setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public String getMessage() {
        return message;
    }

    public LoggerEntity setMessage(String message) {
        this.message = message;
        return this;
    }

    public Object getResult() {
        return result;
    }

    public LoggerEntity setResult(Object result) {
        this.result = result;
        return this;
    }

    public long getExecTime() {
        return execTime;
    }

    public LoggerEntity setExecTime(long execTime) {
        this.execTime = execTime;
        return this;
    }

    public String getApp() {
        return app;
    }

    public LoggerEntity setApp(String app) {
        this.app = app;
        return this;
    }
}
