package com.rocoinfo.aop.logger.principal;

import com.rocoinfo.aop.logger.entity.Principal;

import javax.servlet.ServletRequest;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/6/30 下午2:53</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class PrincipalHandlerHelper {

    /**
     * 获取当前登录用户
     */
    public PrincipalHandler principalHandler;

    /**
     * 根据ServletRequest获取当前登录用户
     */
    public ServletRequestPrincipalHandler servletRequestPrincipalHandler;

    private PrincipalHandlerHelper(PrincipalHandler principalHandler) {
        this.principalHandler = principalHandler;
    }

    private PrincipalHandlerHelper(ServletRequestPrincipalHandler servletRequestPrincipalHandler) {
        this.servletRequestPrincipalHandler = servletRequestPrincipalHandler;
    }

    public static PrincipalHandlerHelper getInstance(PrincipalHandler principalHandler) {
        return new PrincipalHandlerHelper(principalHandler);
    }

    public static PrincipalHandlerHelper getInstance(ServletRequestPrincipalHandler servletRequestPrincipalHandler) {
        return new PrincipalHandlerHelper(servletRequestPrincipalHandler);
    }

    /**
     * 获取当前登录用户
     *
     * @param request
     * @return
     */
    public Principal getPrincipal(ServletRequest request) {
        if (principalHandler != null) {
            return this.principalHandler.getPrincipal();
        }

        if (servletRequestPrincipalHandler != null) {
            return this.servletRequestPrincipalHandler.getPrincipal(request);
        }

        return null;
    }

    /**
     * 获取当前登录用户的用户名
     *
     * @param request
     * @return
     */
    public String getUsername(ServletRequest request) {
        Principal principal = this.getPrincipal(request);
        return principal == null ? "" : principal.getUsername();
    }
}
