/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.common.api.response;

import com.rocoinfo.common.api.enums.CommonResultEnum;
import java.io.Serializable;

public class CommonResponse<T>
implements Serializable {
    private T result;
    private String resultCode;
    private String resultDesc;

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultDesc() {
        return this.resultDesc;
    }

    public void setResultDesc(String resultDesc) {
        this.resultDesc = resultDesc;
    }

    public static CommonResponse buildSuccessResp() {
        return CommonResponse.buildResp(CommonResultEnum.SUCCESS.getCode(), CommonResultEnum.SUCCESS.getDesc());
    }

    public static CommonResponse buildSuccessResp(Object result) {
        return CommonResponse.buildResp(CommonResultEnum.SUCCESS.getCode(), CommonResultEnum.SUCCESS.getDesc(), result);
    }

    public static CommonResponse buildResp(String resultCode, String resultDesc) {
        CommonResponse commonResponse = new CommonResponse();
        commonResponse.setResultCode(resultCode);
        commonResponse.setResultDesc(resultDesc);
        return commonResponse;
    }

    public static CommonResponse buildErrorResp() {
        return CommonResponse.buildResp(CommonResultEnum.UNKNOWN_EXCEPTION);
    }

    public static CommonResponse buildErrorResp(Throwable e) {
        return CommonResponse.buildResp(CommonResultEnum.UNKNOWN_EXCEPTION.getCode(), e.toString());
    }

    public static CommonResponse buildErrorResp(String message) {
        return CommonResponse.buildResp(CommonResultEnum.UNKNOWN_EXCEPTION.getCode(), message);
    }

    public static CommonResponse buildResp(String resultCode, String resultDesc, Object result) {
        CommonResponse<Object> commonResponse = new CommonResponse<Object>();
        commonResponse.setResultCode(resultCode);
        commonResponse.setResultDesc(resultDesc);
        commonResponse.setResult(result);
        return commonResponse;
    }

    public static CommonResponse buildResp(CommonResultEnum commonResultEnum) {
        CommonResponse commonResponse = new CommonResponse();
        commonResponse.setResultCode(commonResultEnum.getCode());
        commonResponse.setResultDesc(commonResultEnum.getDesc());
        return commonResponse;
    }

    public static CommonResponse buildResp(CommonResultEnum commonResultEnum, Object result) {
        CommonResponse<Object> commonResponse = new CommonResponse<Object>();
        commonResponse.setResultCode(commonResultEnum.getCode());
        commonResponse.setResultDesc(commonResultEnum.getDesc());
        commonResponse.setResult(result);
        return commonResponse;
    }

    public String toString() {
        return "CommonResponse{result=" + this.result + ", resultCode='" + this.resultCode + '\'' + ", resultDesc='" + this.resultDesc + '\'' + '}';
    }
}

