/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.common.service;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.rocoinfo.common.dao.CrudDao;
import com.rocoinfo.common.service.BaseService;
import com.rocoinfo.dto.page.PageTable;
import com.rocoinfo.dto.page.Pagination;
import com.rocoinfo.entity.IdEntity;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class CrudService<D extends CrudDao<T>, T extends IdEntity>
extends BaseService<T> {
    @Autowired
    protected D entityDao;
    private static final String PAGE_SORT = "sort";

    @Override
    public T getById(Long id) {
        if (id == null || id < 1L) {
            return null;
        }
        return (T)((IdEntity)this.entityDao.getById(id));
    }

    @Override
    @Transactional
    public int insert(T entity) {
        if (entity == null) {
            return 0;
        }
        return this.entityDao.insert(entity);
    }

    @Override
    public int update(T entity) {
        if (entity == null || ((IdEntity)entity).getId() == null) {
            return 0;
        }
        return this.entityDao.update(entity);
    }

    @Override
    public int deleteById(Long id) {
        if (id == null || id < 1L) {
            return 0;
        }
        return this.entityDao.deleteById(id);
    }

    @Override
    public List<T> findAll() {
        return this.entityDao.findAll();
    }

    @Override
    public PageTable searchScrollPage(Map<String, Object> params, Pagination page) {
        params.put(PAGE_SORT, page.getSort());
        PageHelper.offsetPage((int)page.getOffset(), (int)page.getLimit());
        Page result = (Page)this.entityDao.search(params);
        return new PageTable(result.getResult(), result.getTotal());
    }
}

