/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.config.db;

import com.alibaba.druid.pool.DruidDataSource;
import com.rocoinfo.config.db.DataSourceProperties;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DataSourceProperties.class})
public class DataSourceConfig {
    @Autowired
    private DataSourceProperties props;

    @Bean
    public DataSource dataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(this.props.getDriverClassName());
        dataSource.setUrl(this.props.getUrl());
        dataSource.setUsername(this.props.getUsername());
        dataSource.setPassword(this.props.getPassword());
        dataSource.setInitialSize(this.props.getInitialSize());
        dataSource.setMinIdle(this.props.getMinIdle());
        dataSource.setMaxActive(this.props.getMaxActive());
        dataSource.setMaxWait(this.props.getMaxWait());
        dataSource.setTimeBetweenEvictionRunsMillis(this.props.getTimeBetweenEvictionRunsMillis());
        dataSource.setMinEvictableIdleTimeMillis(this.props.getMinEvictableIdleTimeMillis());
        dataSource.setValidationQuery(this.props.getValidationQuery());
        dataSource.setTestWhileIdle(this.props.isTestWhileIdle());
        dataSource.setTestOnBorrow(this.props.isTestOnBorrow());
        dataSource.setTestOnReturn(this.props.isTestOnReturn());
        dataSource.setPoolPreparedStatements(dataSource.isPoolPreparedStatements());
        try {
            dataSource.setFilters(this.props.getFilters());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dataSource;
    }
}

