/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.dto;

public class StatusDto<T> {
    private static final String SUCCESS_MSG = "Success!";
    private static final String FAILURE_MSG = "failure!";
    private static final String SUCCESS_CODE = "1";
    private static final String FAILURE_CODE = "0";
    private String code;
    private String message;
    private T data;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return SUCCESS_CODE.equals(this.code);
    }

    public StatusDto(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static StatusDto buildSuccess() {
        return new StatusDto<Object>(SUCCESS_CODE, SUCCESS_MSG, null);
    }

    public static StatusDto buildSuccess(String message) {
        return new StatusDto<Object>(SUCCESS_CODE, message, null);
    }

    public static <E> StatusDto<E> buildSuccess(E data) {
        return new StatusDto<E>(SUCCESS_CODE, SUCCESS_MSG, data);
    }

    public static <E> StatusDto<E> buildSuccess(String message, E data) {
        return new StatusDto<E>(SUCCESS_CODE, message, data);
    }

    public static StatusDto buildFailure() {
        return new StatusDto<Object>(FAILURE_CODE, FAILURE_MSG, null);
    }

    public static StatusDto buildFailure(String message) {
        return new StatusDto<Object>(FAILURE_CODE, message, null);
    }

    public static <E> StatusDto<E> buildFailure(E data) {
        return new StatusDto<E>(FAILURE_CODE, SUCCESS_MSG, data);
    }

    public static <E> StatusDto<E> buildFailure(String message, E data) {
        return new StatusDto<E>(FAILURE_CODE, message, data);
    }

    public static StatusDto buildWithCode(String code, String message) {
        return new StatusDto<Object>(code, message, null);
    }

    public String toString() {
        String dataString = this.data != null ? this.data.toString() : "null";
        return "{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", data=" + dataString + '}';
    }
}

