/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.entity.system;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.rocoinfo.entity.IdEntity;
import com.rocoinfo.entity.system.Permission;
import com.rocoinfo.entity.system.Role;
import com.rocoinfo.enumeration.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.data.annotation.Transient;

public class AdminUser
extends IdEntity {
    @NotEmpty(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=20, message="\u7528\u6237\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720")
    private String username;
    @JsonIgnore
    private String password;
    @Transient
    @JsonIgnore
    private String plainPassword;
    @JsonIgnore
    private String salt;
    @NotEmpty(message="\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=20, message="\u59d3\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720")
    private String name;
    @NotEmpty(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=20, message="\u624b\u673a\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720")
    private String mobile;
    @NotEmpty(message="\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=50, message="\u90ae\u7bb1\u957f\u5ea6\u4e0d\u8d85\u8fc750")
    private String email;
    private Status status;
    private Boolean deleted;
    @Transient
    @JsonIgnore
    private List<Role> roles;

    public AdminUser() {
    }

    public AdminUser(Long id) {
        this.id = id;
    }

    public List<String> getRoleNameList() {
        if (CollectionUtils.isEmpty(this.roles)) {
            return Collections.emptyList();
        }
        ArrayList roleNames = Lists.newArrayListWithCapacity((int)this.roles.size());
        for (Role role : this.roles) {
            roleNames.add(role.getName());
        }
        return roleNames;
    }

    public LinkedHashSet<String> getPermissions() {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty(this.roles)) {
            for (Role role : this.roles) {
                List<Permission> permission = role.getPermission();
                if (permission == null) continue;
                for (Permission perm : permission) {
                    permissions.add(perm.getPermission());
                }
            }
        }
        return permissions;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getPlainPassword() {
        return this.plainPassword;
    }

    public void setPlainPassword(String plainPassword) {
        this.plainPassword = plainPassword;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }
}

