/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.service.system;

import com.rocoinfo.common.service.CrudService;
import com.rocoinfo.dto.StatusDto;
import com.rocoinfo.entity.system.AdminUser;
import com.rocoinfo.enumeration.Status;
import com.rocoinfo.repository.system.AdminUserDao;
import com.rocoinfo.utils.PasswordUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdminUserService
extends CrudService<AdminUserDao, AdminUser> {
    private static String DEFAULT_PASSWORD = "123456";

    @Transactional(rollbackFor={Exception.class})
    public StatusDto create(AdminUser user) {
        if (this.getByUsername(user.getUsername()) != null) {
            return StatusDto.buildFailure("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
        }
        String salt = PasswordUtil.generateSalt();
        user.setSalt(salt);
        user.setPassword(PasswordUtil.entryptUserPassword(DEFAULT_PASSWORD, salt));
        user.setStatus(Status.OPEN);
        user.setDeleted(false);
        super.insert(user);
        return StatusDto.buildSuccess();
    }

    public AdminUser getByUsername(String username) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            return ((AdminUserDao)this.entityDao).getByUsername(username);
        }
        return null;
    }

    public StatusDto edit(AdminUser user) {
        AdminUser existUser = this.getByUsername(user.getUsername());
        if (existUser != null && !existUser.getId().equals(user.getId())) {
            return StatusDto.buildFailure("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
        }
        super.update(user);
        return StatusDto.buildSuccess();
    }

    @Transactional(rollbackFor={Exception.class})
    public StatusDto resetPwd(Long id) {
        if (id == null || this.getById(id) == null) {
            return StatusDto.buildFailure("\u7528\u6237id\u4e3anull\u6216\u67e5\u8be2\u4e0d\u5230\u6b64\u7528\u6237\u4fe1\u606f");
        }
        AdminUser user = new AdminUser(id);
        String salt = PasswordUtil.generateSalt();
        user.setSalt(salt);
        user.setPassword(PasswordUtil.entryptUserPassword(DEFAULT_PASSWORD, salt));
        int i = this.update(user);
        if (i > 0) {
            return StatusDto.buildSuccess();
        }
        return StatusDto.buildFailure();
    }

    public AdminUser getAllInfoByUsername(String username) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            return ((AdminUserDao)this.entityDao).getAllInfoByUsername(username);
        }
        return null;
    }

    public AdminUser getAllInfoById(Long id) {
        if (id != null) {
            return ((AdminUserDao)this.entityDao).getAllInfoById(id);
        }
        return null;
    }

    public StatusDto modifyPwd(Long id, String oldPwd, String newPwd) {
        AdminUser user = (AdminUser)((AdminUserDao)this.entityDao).getById(id);
        try {
            if (user.getPassword().equals(PasswordUtil.hashPassword(oldPwd, user.getSalt()))) {
                AdminUser u = new AdminUser(id);
                String salt = PasswordUtil.generateSalt();
                u.setSalt(salt);
                u.setPassword(PasswordUtil.entryptUserPassword(newPwd, salt));
                ((AdminUserDao)this.entityDao).update(u);
                return StatusDto.buildSuccess("\u4fee\u6539\u5bc6\u7801\u6210\u529f\uff01");
            }
            return StatusDto.buildFailure("\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff01");
        }
        catch (Exception e) {
            return StatusDto.buildFailure("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff01");
        }
    }
}

