/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.service.system;

import com.rocoinfo.common.service.CrudService;
import com.rocoinfo.dto.StatusDto;
import com.rocoinfo.entity.system.AdminUserRole;
import com.rocoinfo.entity.system.Permission;
import com.rocoinfo.entity.system.Role;
import com.rocoinfo.entity.system.RolePermission;
import com.rocoinfo.repository.system.RoleDao;
import com.rocoinfo.repository.system.RolePermissionDao;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleService
extends CrudService<RoleDao, Role> {
    @Autowired
    private RolePermissionDao rolePermissionDao;

    @Transactional(rollbackFor={Exception.class})
    public StatusDto saveOrUpdate(Role role) {
        Role tempRole = ((RoleDao)this.entityDao).getByNameExceptId(role.getId(), role.getName());
        if (tempRole != null) {
            return StatusDto.buildFailure("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        int i = role.getId() != null ? super.update(role) : super.insert(role);
        if (i <= 0) {
            StatusDto.buildFailure("\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return StatusDto.buildSuccess("\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public StatusDto deleteRole(Long id) {
        ((RoleDao)this.entityDao).deleteById(id);
        ((RoleDao)this.entityDao).deleteUserRolesByRoleId(id);
        this.rolePermissionDao.deleteByRoleId(id);
        return StatusDto.buildSuccess("\u5220\u9664\u89d2\u8272\u6210\u529f\uff01");
    }

    public List<Permission> findRolePermission(Long id) {
        return this.rolePermissionDao.findRolePermission(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public Object setRolePermissions(Long id, List<Long> permissionIds) {
        Role role = (Role)((RoleDao)this.entityDao).getById(id);
        if (role == null) {
            return StatusDto.buildFailure("\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u6b64\u89d2\u8272\u4fe1\u606f\uff01");
        }
        this.rolePermissionDao.deleteByRoleId(id);
        if (CollectionUtils.isNotEmpty(permissionIds)) {
            List<RolePermission> rolePermissions = permissionIds.stream().map(o -> new RolePermission(id, (Long)o)).collect(Collectors.toList());
            this.rolePermissionDao.batchInsert(rolePermissions);
        }
        return StatusDto.buildSuccess("\u6743\u9650\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    public List<Role> getRolesByUserId(Long userId) {
        return ((RoleDao)this.entityDao).getRolesByUserId(userId);
    }

    @Transactional(rollbackFor={Exception.class})
    public StatusDto setRolesByUserId(Long userId, List<Long> roleIds) {
        if (userId == null || CollectionUtils.isEmpty(roleIds)) {
            return StatusDto.buildFailure("id\u4e3anull\u6216\u6ca1\u6709\u9009\u62e9\u89d2\u8272");
        }
        ((RoleDao)this.entityDao).deleteUserRolesByUserId(userId);
        List<AdminUserRole> userRoles = roleIds.stream().map(o -> new AdminUserRole(userId, (Long)o)).collect(Collectors.toList());
        ((RoleDao)this.entityDao).batchInsertUserRole(userRoles);
        return StatusDto.buildSuccess();
    }
}

