/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class DataSourceUtil {
    public static final String DATASOURCE_FILENAME = "application.properties";
    public static final String DATASOURCE_KEY = "spring.datasource";
    public static final String DATASOURCE_KEY_2 = "batch.datasource";
    public static final String QUARTZ_COLONY = "quartz.colony";
    public static final String URL_KEY = ".url";
    public static final String USERNAME_KEY = ".username";
    public static final String PASSWORD_KEY = ".password";

    public static Properties getProperties() throws Exception {
        InputStream in = null;
        if (in == null && (in = Thread.currentThread().getContextClassLoader().getResourceAsStream(DATASOURCE_FILENAME)) == null) {
            throw new Exception("The data source configuration file for path\u3010application.properties\u3011was not found!");
        }
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String getDatabaseURL() throws Exception {
        return DataSourceUtil.getDataSourceValueByType(URL_KEY);
    }

    public static String getUserOfDatabase() throws Exception {
        return DataSourceUtil.getDataSourceValueByType(USERNAME_KEY);
    }

    public static String getPasswordOfDatabase() throws Exception {
        return DataSourceUtil.getDataSourceValueByType(PASSWORD_KEY);
    }

    public static String getQuartzColony() throws Exception {
        Properties p = DataSourceUtil.getProperties();
        return p.getProperty(QUARTZ_COLONY);
    }

    public static Connection getConnection() throws Exception {
        String url = DataSourceUtil.getDataSourceValueByType(URL_KEY);
        String username = DataSourceUtil.getDataSourceValueByType(USERNAME_KEY);
        String password = DataSourceUtil.getDataSourceValueByType(PASSWORD_KEY);
        return DriverManager.getConnection(url, username, password);
    }

    public static List<String> getAllTableNames(Connection conn, String database, String schem, String tableName) {
        ArrayList<String> tableNames = new ArrayList<String>();
        if (conn != null) {
            try {
                DatabaseMetaData metadata = conn.getMetaData();
                ResultSet rest = metadata.getTables(database, schem.toUpperCase(), tableName.toUpperCase(), new String[]{"TABLE"});
                while (rest.next()) {
                    tableNames.add(rest.getString("TABLE_NAME"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return tableNames;
    }

    private static String getDataSourceValueByType(String type) throws Exception {
        Properties p = DataSourceUtil.getProperties();
        String value = p.getProperty(DATASOURCE_KEY + type);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = p.getProperty(DATASOURCE_KEY_2 + type);
        }
        return value;
    }
}

