/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils;

import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.Validate;

public final class RandomUtil {
    private static final String RAND_CHARS = "0123456789abcdefghigklmnopqrstuvtxyzABCDEFGHIGKLMNOPQRSTUVWXYZ";
    private static final int[] PREFIX = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static Random random = new Random();

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid2() {
        return RandomUtil.uuid().replaceAll("-", "");
    }

    public static int rand() {
        int n = random.nextInt();
        n = n == Integer.MIN_VALUE ? 0 : Math.abs(n);
        return n;
    }

    public static int rand(int max) {
        return random.nextInt(max);
    }

    public static int rand(int min, int max) {
        if (min < max) {
            if (min > 0) {
                return RandomUtil.rand(max - min) + min;
            }
            return RandomUtil.rand(max);
        }
        return min;
    }

    public static long randLong() {
        long n = random.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        return n;
    }

    public static long randLong(long min, long max) {
        Validate.isTrue((max >= min ? 1 : 0) != 0, (String)"Start value must be smaller or equal to end value.", (Object[])new Object[0]);
        if (min == max) {
            return min;
        }
        return (long)((double)min + (double)(max - min) * random.nextDouble());
    }

    public static long randLongFixLength(int digit) {
        if (digit >= 19 || digit <= 0) {
            throw new IllegalArgumentException("digit should between 1 and 18(1<=digit<=18)");
        }
        String s = RandomStringUtils.randomNumeric((int)(digit - 1));
        return Long.parseLong(RandomUtil.getPrefix() + s);
    }

    public static long randLongRandomLength(int minDigit, int maxDigit) {
        if (minDigit > maxDigit) {
            throw new IllegalArgumentException("minDigit > maxDigit");
        }
        if (minDigit <= 0 || maxDigit >= 19) {
            throw new IllegalArgumentException("minDigit <=0 || maxDigit>=19");
        }
        return RandomUtil.randLongFixLength(minDigit + RandomUtil.getDigit(maxDigit - minDigit));
    }

    public static String getRandStr(int length, int randType) {
        StringBuffer hash = new StringBuffer(length);
        if (randType == 1) {
            for (int i = 0; i < length; ++i) {
                hash.append(RAND_CHARS.charAt(10 + random.nextInt(52)));
            }
        } else if (randType == 2) {
            for (int i = 0; i < length; ++i) {
                hash.append(RAND_CHARS.charAt(random.nextInt(10)));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                hash.append(RAND_CHARS.charAt(random.nextInt(62)));
            }
        }
        return hash.toString();
    }

    public static String toFixdLengthString(int num, int fixedLength) {
        StringBuffer sb = new StringBuffer();
        String strNum = String.valueOf(num);
        if (fixedLength - strNum.length() < 0) {
            throw new RuntimeException("\u5c06\u6570\u5b57" + num + "\u8f6c\u5316\u4e3a\u957f\u5ea6\u4e3a" + fixedLength + "\u7684\u5b57\u7b26\u4e32\u53d1\u751f\u5f02\u5e38\uff01");
        }
        sb.append(RandomUtil.generateZeroString(fixedLength - strNum.length()));
        sb.append(strNum);
        return sb.toString();
    }

    private static int getDigit(int max) {
        return random.nextInt(max + 1);
    }

    private static String getPrefix() {
        return PREFIX[random.nextInt(PREFIX.length)] + "";
    }

    private static String generateZeroString(int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }

    public static String randomStringRandomLength(int minLength, int maxLength) {
        return RandomStringUtils.random((int)RandomUtil.rand(minLength, maxLength), (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)random);
    }

    public static String randBigSmallLetterNumberFixLength(int length) {
        String str = "";
        for (int i = 0; i < length; ++i) {
            int intVal = (int)(Math.random() * 58.0 + 65.0);
            if (intVal >= 91 && intVal <= 96) {
                --i;
            }
            if (intVal >= 91 && intVal <= 96) continue;
            str = intVal % 2 == 0 ? str + (char)intVal : str + (int)(Math.random() * 10.0);
        }
        return str;
    }

    public static String randSmallLetterNumberFixLength(int length) {
        String str = "";
        for (int i = 0; i < length; ++i) {
            int intVal = (int)(Math.random() * 26.0 + 97.0);
            str = intVal % 2 == 0 ? str + (char)intVal : str + (int)(Math.random() * 10.0);
        }
        return str;
    }

    public static String randBigLetterNumberFixLength(int length) {
        String str = "";
        for (int i = 0; i < length; ++i) {
            int intVal = (int)(Math.random() * 26.0 + 65.0);
            str = intVal % 2 == 0 ? str + (char)intVal : str + (int)(Math.random() * 10.0);
        }
        return str;
    }
}

