/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.base;

import com.rocoinfo.utils.base.BooleanUtil;
import com.rocoinfo.utils.io.FileUtil;
import com.rocoinfo.utils.io.URLResourceUtil;
import com.rocoinfo.utils.text.Charsets;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesUtil.class);

    public static Boolean getBoolean(Properties p, String name, Boolean defaultValue) {
        return BooleanUtil.toBooleanObject(p.getProperty(name), defaultValue);
    }

    public static Integer getInt(Properties p, String name, Integer defaultValue) {
        return NumberUtils.toInt((String)p.getProperty(name), (int)defaultValue);
    }

    public static Long getLong(Properties p, String name, Long defaultValue) {
        return NumberUtils.toLong((String)p.getProperty(name), (long)defaultValue);
    }

    public static Double getDouble(Properties p, String name, Double defaultValue) {
        return NumberUtils.toDouble((String)p.getProperty(name), (double)defaultValue);
    }

    public static String getString(Properties p, String name, String defaultValue) {
        return p.getProperty(name, defaultValue);
    }

    public static Properties loadFromFile(String generalPath) {
        Properties p = new Properties();
        try (InputStreamReader reader = new InputStreamReader(URLResourceUtil.asStream(generalPath), Charsets.UTF_8);){
            p.load(reader);
        }
        catch (IOException e) {
            logger.warn("Load property from " + generalPath + " failed", (Throwable)e);
        }
        return p;
    }

    public static Properties loadFromString(String content) {
        Properties p = new Properties();
        try (StringReader reader = new StringReader(content);){
            p.load(reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }

    public static void storePropertiesToFile(Properties props, String filePath) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            props.store(fos, "By CommonUtils.storePropertiesToFile, " + new Date());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(fos);
                throw throwable;
            }
        }
        FileUtil.closeIO(fos);
    }
}

