/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.excel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.utils.ArithUtil;
import com.rocoinfo.utils.excel.ExcelHeader;
import com.rocoinfo.utils.excel.ExcelTemplate;
import com.rocoinfo.utils.excel.ExcelTitle;
import com.rocoinfo.utils.reflect.ReflectionUtil;
import com.rocoinfo.utils.time.DateFormatUtil;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelUtil {
    private static String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd", "MM/dd/yyyy", "yyyy/MM/dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm"};
    private static ExcelUtil util = new ExcelUtil();

    private ExcelUtil() {
    }

    public static ExcelUtil getInstance() {
        return util;
    }

    public <E> List<E> readExcel2ObjsByFile(File file, Class<E> clz) {
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((File)file);
            return this.handleExcel2Objs(wb, clz, 0);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    private <E> ExcelTemplate handleObj2Excel(String excelTemplateFile, List<E> exportDataList, Class<E> clz, boolean isClassPath) {
        ExcelTemplate template = new ExcelTemplate();
        if (isClassPath) {
            template.readTemplateByClasspath(excelTemplateFile);
        } else {
            template.readTemplateByPath(excelTemplateFile);
        }
        List<ExcelHeader> headers = this.getHeaderList(clz);
        template.createNewRow();
        for (ExcelHeader eh : headers) {
            template.createCell(eh.getTitle());
        }
        for (ExcelHeader rowData : exportDataList) {
            template.createNewRow();
            for (ExcelHeader eh : headers) {
                this.createCellAndWriteValue(template, rowData, eh);
            }
        }
        return template;
    }

    private <E> void createCellAndWriteValue(ExcelTemplate template, E rowData, ExcelHeader excelHeader) {
        Object propValue = ReflectionUtil.getFieldValue(rowData, excelHeader.getPropertyName());
        if (propValue == null) {
            propValue = "";
        }
        if (propValue instanceof Date) {
            template.createCell((Date)propValue);
        } else if (propValue instanceof Double) {
            template.createCell((Double)propValue);
        } else if (propValue instanceof Integer) {
            template.createCell((Integer)propValue);
        } else if (propValue instanceof Boolean) {
            template.createCell((Boolean)propValue);
        } else {
            template.createCell(propValue.toString());
        }
    }

    public <E> void exportObj2ExcelByTemplate(Map<String, String> variableExtras, String excelTemplatePath, OutputStream os, List<E> exportDataList, Class<E> clz, boolean isClasspath) {
        ExcelTemplate et = this.handleObj2Excel(excelTemplatePath, exportDataList, clz, isClasspath);
        et.replaceFinalData(variableExtras);
        et.wirteToStream(os);
    }

    public <E> void exportObj2ExcelByTemplate(Map<String, String> variableExtras, String excelTemplatePath, String outPath, List<E> exportDataList, Class<E> clz, boolean isClasspath) {
        ExcelTemplate et = this.handleObj2Excel(excelTemplatePath, exportDataList, clz, isClasspath);
        et.replaceFinalData(variableExtras);
        et.writeToFile(outPath);
    }

    public <E> void exportObj2ExcelByTemplate(Properties variableExtras, String excelTemplatePath, OutputStream os, List<E> exportDataList, Class<E> clz, boolean isClasspath) {
        ExcelTemplate et = this.handleObj2Excel(excelTemplatePath, exportDataList, clz, isClasspath);
        et.replaceFinalData(variableExtras);
        et.wirteToStream(os);
    }

    public <E> void exportObj2ExcelByTemplate(Properties variableExtras, String excelTemplatePath, String outFile, List<E> exportDataList, Class<E> clz, boolean isClasspath) {
        ExcelTemplate et = this.handleObj2Excel(excelTemplatePath, exportDataList, clz, isClasspath);
        et.replaceFinalData(variableExtras);
        et.writeToFile(outFile);
    }

    private <E> Workbook handleObj2Excel(List<E> exportDataList, Class<E> clz, boolean isXssf) {
        Object wb = null;
        wb = isXssf ? new XSSFWorkbook() : new HSSFWorkbook();
        Sheet sheet = wb.createSheet();
        Row row = sheet.createRow(0);
        List<ExcelHeader> headers = this.getHeaderList(clz);
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue(headers.get(i).getTitle());
        }
        Object obj = null;
        for (int rowIdx = 0; rowIdx < exportDataList.size(); ++rowIdx) {
            row = sheet.createRow(rowIdx + 1);
            obj = exportDataList.get(rowIdx);
            for (int colIdx = 0; colIdx < headers.size(); ++colIdx) {
                Cell cell = row.createCell(colIdx);
                Object propValue = ReflectionUtil.getFieldValue(obj, headers.get(colIdx).getPropertyName());
                if (propValue == null) {
                    propValue = "";
                }
                if (propValue instanceof Date) {
                    cell.setCellValue((Date)propValue);
                    continue;
                }
                if (propValue instanceof Double) {
                    cell.setCellValue(((Double)propValue).doubleValue());
                    continue;
                }
                if (propValue instanceof Integer) {
                    cell.setCellValue((double)((Integer)propValue).intValue());
                    continue;
                }
                if (propValue instanceof Boolean) {
                    cell.setCellValue(((Boolean)propValue).booleanValue());
                    continue;
                }
                cell.setCellValue(propValue.toString());
            }
        }
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <E> void exportObj2Excel(String outFileAbsolutePath, List<E> exportDataList, Class<E> clz, boolean isXssf) {
        Workbook wb = this.handleObj2Excel(exportDataList, clz, isXssf);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFileAbsolutePath);
            wb.write((OutputStream)fos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            IOUtils.closeQuietly((OutputStream)fos);
            ExcelUtil.closeWorkbookQuietly(wb);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    ExcelUtil.closeWorkbookQuietly(wb);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fos);
            ExcelUtil.closeWorkbookQuietly(wb);
        }
        IOUtils.closeQuietly((OutputStream)fos);
        ExcelUtil.closeWorkbookQuietly(wb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> void exportObj2Excel(OutputStream os, List<E> exportDataList, Class<E> clz, boolean isXssf) {
        Workbook wb = null;
        try {
            wb = this.handleObj2Excel(exportDataList, clz, isXssf);
            wb.write(os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public <E> List<E> readExcel2ObjsByClasspath(String clsPath, Class<E> clz, int titleRowIndex) {
        List<E> list;
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)this.getClass().getResourceAsStream(clsPath));
            list = this.handleExcel2Objs(wb, clz, titleRowIndex);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            ExcelUtil.closeWorkbookQuietly(wb);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    ExcelUtil.closeWorkbookQuietly(wb);
                    throw throwable;
                }
            }
            ExcelUtil.closeWorkbookQuietly(wb);
        }
        ExcelUtil.closeWorkbookQuietly(wb);
        return list;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> List<E> readExcel2ObjsByStream(InputStream inputStream, Class<E> clz) {
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)inputStream);
            List<E> list = this.handleExcel2Objs(wb, clz, 0);
            return list;
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ExcelUtil.closeWorkbookQuietly(wb);
        }
        return Collections.emptyList();
    }

    public static void closeWorkbookQuietly(Workbook wb) {
        if (wb != null) {
            try {
                wb.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public <E> List<E> readExcel2ObjsByPath(String path, Class<E> clz, int titleRowIndex) {
        List<E> list;
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((File)new File(path));
            list = this.handleExcel2Objs(wb, clz, titleRowIndex);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            ExcelUtil.closeWorkbookQuietly(wb);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    ExcelUtil.closeWorkbookQuietly(wb);
                    throw throwable;
                }
            }
            ExcelUtil.closeWorkbookQuietly(wb);
        }
        ExcelUtil.closeWorkbookQuietly(wb);
        return list;
        return null;
    }

    public <E> List<E> readExcel2ObjsByClasspath(String clsPath, Class<E> clz) {
        return this.readExcel2ObjsByClasspath(clsPath, clz, 0);
    }

    public <E> List<E> readExcel2ObjsByPath(String path, Class<E> clz) {
        return this.readExcel2ObjsByPath(path, clz, 0);
    }

    private Object getCellValue(Cell cell) {
        Object cellValue = null;
        switch (cell.getCellType()) {
            case 3: {
                cellValue = "";
                break;
            }
            case 4: {
                cellValue = cell.getBooleanCellValue();
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = cell.getDateCellValue();
                    break;
                }
                cellValue = ArithUtil.formatMoney(cell.getNumericCellValue());
                break;
            }
            case 1: {
                cellValue = StringUtils.trimToEmpty((String)cell.getStringCellValue());
                break;
            }
            default: {
                cellValue = StringUtils.trimToEmpty((String)cell.getStringCellValue());
            }
        }
        return cellValue;
    }

    public <E> List<E> handleExcel2ObjsOfSheet(Sheet sheet, Class<E> clz, int titleRowIndex) {
        ArrayList<E> entityList = null;
        Row row = sheet.getRow(titleRowIndex);
        entityList = new ArrayList<E>();
        Map<Integer, String> colIndexPropertyMap = this.getHeaderMap(row, clz);
        if (colIndexPropertyMap == null || colIndexPropertyMap.isEmpty()) {
            throw new RuntimeException("\u8981\u8bfb\u53d6\u7684Excel\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u68c0\u67e5\u662f\u5426\u8bbe\u5b9a\u4e86\u5408\u9002\u7684\u884c");
        }
        for (int dataRowIdx = titleRowIndex + 1; dataRowIdx <= sheet.getLastRowNum(); ++dataRowIdx) {
            Object firstCellValue;
            row = sheet.getRow(dataRowIdx);
            Cell firstCol = row.getCell(0);
            if (firstCol == null || (firstCellValue = this.getCellValue(firstCol)) == null || firstCellValue instanceof String && StringUtils.isEmpty((CharSequence)firstCellValue.toString())) continue;
            try {
                E obj = clz.newInstance();
                for (Cell cell : row) {
                    String number;
                    Object cellValue = this.getCellValue(cell);
                    if (cellValue == null || !StringUtils.isNotBlank((CharSequence)cellValue.toString())) continue;
                    Object castedCellValue = null;
                    int colIndx = cell.getColumnIndex();
                    String fieldName = colIndexPropertyMap.get(colIndx);
                    if (StringUtils.isEmpty((CharSequence)fieldName)) continue;
                    Field field = ReflectionUtil.getField(obj, fieldName);
                    Class<?> type = field.getType();
                    if (type.equals(Integer.class)) {
                        if (StringUtils.isNotEmpty((CharSequence)cellValue.toString())) {
                            castedCellValue = Integer.valueOf(cellValue.toString());
                        }
                    } else if (type.equals(Long.class)) {
                        if (StringUtils.isNotEmpty((CharSequence)cellValue.toString())) {
                            castedCellValue = Long.valueOf(cellValue.toString());
                        }
                    } else if (type.equals(Double.class)) {
                        if (StringUtils.isNotEmpty((CharSequence)cellValue.toString())) {
                            number = cellValue.toString();
                            castedCellValue = number.endsWith("%") ? Double.valueOf(ArithUtil.percentToDouble(number)) : Double.valueOf(NumberUtils.toDouble((String)number));
                        }
                    } else if (type.equals(BigDecimal.class)) {
                        if (StringUtils.isNotEmpty((CharSequence)cellValue.toString())) {
                            number = cellValue.toString();
                            castedCellValue = number.endsWith("%") ? new BigDecimal(ArithUtil.percentToDouble(number)) : new BigDecimal(number);
                        }
                    } else if (type.equals(Boolean.class)) {
                        castedCellValue = cellValue.getClass().equals(Boolean.class) ? cellValue : Boolean.valueOf(Boolean.parseBoolean(cellValue.toString()));
                    } else if (type.equals(Date.class)) {
                        castedCellValue = cellValue.getClass().equals(Date.class) ? cellValue : DateUtils.parseDate((String)cellValue.toString(), (String[])DATE_PATTERNS);
                    } else if (type.isEnum()) {
                        String enumString = cellValue.toString();
                        if (StringUtils.isNotBlank((CharSequence)enumString)) {
                            castedCellValue = Enum.valueOf(type, enumString);
                        }
                    } else {
                        castedCellValue = type.equals(String.class) ? cellValue.toString() : cellValue;
                    }
                    field.set(obj, castedCellValue);
                }
                entityList.add(obj);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return entityList;
    }

    private <E> List<E> handleExcel2Objs(Workbook wb, Class<E> clz, int titleRowIndex) {
        Sheet sheet = wb.getSheetAt(0);
        return this.handleExcel2ObjsOfSheet(sheet, clz, titleRowIndex);
    }

    private <E> List<ExcelHeader> getHeaderList(Class<E> clz) {
        ArrayList<ExcelHeader> headers = new ArrayList<ExcelHeader>();
        try {
            PropertyDescriptor[] proertyDescritors;
            BeanInfo info = Introspector.getBeanInfo(clz);
            for (PropertyDescriptor pd : proertyDescritors = info.getPropertyDescriptors()) {
                String propertyName = pd.getName();
                if ("class".equals(propertyName)) continue;
                Field field = ReflectionUtil.getClassField(clz, propertyName);
                Method method = pd.getReadMethod();
                if (!method.isAnnotationPresent(ExcelTitle.class) && (field == null || !field.isAnnotationPresent(ExcelTitle.class))) continue;
                ExcelTitle excelTitle = method.getAnnotation(ExcelTitle.class);
                if (excelTitle == null) {
                    excelTitle = field.getAnnotation(ExcelTitle.class);
                }
                ExcelHeader header = new ExcelHeader(excelTitle.title(), excelTitle.order(), propertyName);
                header.setField(field);
                headers.add(header);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(headers);
        return headers;
    }

    private <E> Map<Integer, String> getHeaderMap(Row titleRow, Class<E> clz) {
        List<ExcelHeader> headers = this.getHeaderList(clz);
        HashMap<Integer, String> maps = new HashMap<Integer, String>();
        block0: for (Cell cell : titleRow) {
            String title = cell.getStringCellValue();
            for (ExcelHeader eh : headers) {
                if (!eh.getTitle().equals(title.trim())) continue;
                maps.put(cell.getColumnIndex(), eh.getPropertyName());
                continue block0;
            }
        }
        return maps;
    }

    public <E> Workbook exportObj2ExcelWithTitleAndFields(List<E> exportDataList, Class<E> clz, boolean isXssf, List<String> titles, List<String> fields) {
        return this.handleObj2ExcelWithTitleAndFields(exportDataList, clz, isXssf, titles, fields);
    }

    private <E> Workbook handleObj2ExcelWithTitleAndFields(List<E> exportDataList, Class<E> clz, boolean isXssf, List<String> titles, List<String> fields) {
        Object wb = null;
        wb = isXssf ? new XSSFWorkbook() : new HSSFWorkbook();
        Sheet sheet = wb.createSheet();
        Row row = sheet.createRow(0);
        int length = titles.size();
        for (int i = 0; i < length; ++i) {
            row.createCell(i).setCellValue(titles.get(i));
        }
        if (CollectionUtils.isNotEmpty(exportDataList)) {
            Object obj = null;
            for (int rowIdx = 0; rowIdx < exportDataList.size(); ++rowIdx) {
                row = sheet.createRow(rowIdx + 1);
                obj = exportDataList.get(rowIdx);
                for (int colIdx = 0; colIdx < length; ++colIdx) {
                    Cell cell = row.createCell(colIdx);
                    String fieldName = fields.get(colIdx);
                    Object propValue = null;
                    try {
                        propValue = BeanUtilsBean.getInstance().getPropertyUtils().getProperty(obj, fieldName);
                    }
                    catch (Exception ex) {
                        try {
                            propValue = ReflectionUtil.invokeGetter(obj, fieldName);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (propValue == null) {
                        propValue = "";
                    }
                    if (propValue instanceof Date) {
                        cell.setCellValue(DateFormatUtil.formatToDate((Date)propValue));
                        continue;
                    }
                    if (propValue instanceof Double) {
                        cell.setCellValue(((Double)propValue).doubleValue());
                        continue;
                    }
                    if (propValue instanceof Integer) {
                        cell.setCellValue((double)((Integer)propValue).intValue());
                        continue;
                    }
                    if (propValue instanceof Boolean) {
                        cell.setCellValue(((Boolean)propValue).booleanValue());
                        continue;
                    }
                    cell.setCellValue(propValue.toString());
                }
            }
        }
        return wb;
    }

    public static <E> Workbook exportFundStandNetValue(List<E> exportDataList, boolean isXssf, Class<E> clz, Map<String, String> fundCodeNameMap, String fundCodeField, String dateField, String valueField) throws Exception {
        Object wb = null;
        wb = isXssf ? new XSSFWorkbook() : new HSSFWorkbook();
        if (CollectionUtils.isEmpty(exportDataList)) {
            return wb;
        }
        Map innerStandNetvalueMap = null;
        HashMap standNetvalueMap = Maps.newHashMap();
        String dateKey = null;
        Object propValue = null;
        for (E obj : exportDataList) {
            propValue = BeanUtilsBean.getInstance().getPropertyUtils().getProperty(obj, dateField);
            dateKey = (String)propValue;
            innerStandNetvalueMap = standNetvalueMap.containsKey(dateKey) ? (Map)standNetvalueMap.get(dateKey) : Maps.newHashMap();
            propValue = BeanUtilsBean.getInstance().getPropertyUtils().getProperty(obj, valueField);
            innerStandNetvalueMap.put(BeanUtilsBean.getInstance().getPropertyUtils().getProperty(obj, fundCodeField).toString(), propValue == null ? null : (BigDecimal)propValue);
            standNetvalueMap.put(dateKey, innerStandNetvalueMap);
        }
        Sheet sheet = wb.createSheet();
        Row row = sheet.createRow(0);
        int length = fundCodeNameMap.size();
        ArrayList<String> fundCodes = new ArrayList<String>(fundCodeNameMap.keySet());
        Collections.sort(fundCodes);
        String fundCode = null;
        Row fundNameRow = sheet.createRow(1);
        fundNameRow.createCell(0).setCellValue("");
        row.createCell(0).setCellValue("");
        for (int i = 0; i < length; ++i) {
            fundCode = (String)fundCodes.get(i);
            row.createCell(i + 1).setCellValue(fundCode);
            fundNameRow.createCell(i + 1).setCellValue(fundCodeNameMap.get(fundCode));
        }
        if (MapUtils.isEmpty((Map)standNetvalueMap)) {
            return wb;
        }
        ArrayList dateKeys = Lists.newArrayList(standNetvalueMap.keySet());
        Collections.sort(dateKeys);
        int contentLen = dateKeys.size();
        BigDecimal value = null;
        for (int rowIdx = 0; rowIdx < contentLen; ++rowIdx) {
            dateKey = (String)dateKeys.get(rowIdx);
            innerStandNetvalueMap = (Map)standNetvalueMap.get(dateKey);
            row = sheet.createRow(rowIdx + 2);
            row.createCell(0).setCellValue(dateKey);
            for (int codeIdx = 0; codeIdx < length; ++codeIdx) {
                value = (BigDecimal)innerStandNetvalueMap.get(fundCodes.get(codeIdx));
                if (value == null) {
                    row.createCell(codeIdx + 1).setCellValue("");
                    continue;
                }
                row.createCell(codeIdx + 1).setCellValue(value.doubleValue());
            }
        }
        return wb;
    }
}

