/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.text;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IDCardUtil {
    private static final Logger logger = LoggerFactory.getLogger(IDCardUtil.class);
    public static final int CHINA_ID_MIN_LENGTH = 15;
    public static final int CHINA_ID_MAX_LENGTH = 18;
    public static final String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    public static final int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    public static final String[] verifyCode = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    public static final int MIN = 1930;
    public static Map<String, String> cityCodes = new HashMap<String, String>();
    public static Map<String, Integer> twFirstCode = new HashMap<String, Integer>();
    public static Map<String, Integer> hkFirstCode = new HashMap<String, Integer>();

    private IDCardUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String conver15CardTo18(String idCard) {
        String idCard18 = "";
        if (idCard.length() != 15) {
            return null;
        }
        if (!IDCardUtil.isNum(idCard)) return null;
        String birthday = idCard.substring(6, 12);
        Date birthDate = null;
        try {
            birthDate = new SimpleDateFormat("yyMMdd").parse(birthday);
        }
        catch (ParseException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        Calendar cal = Calendar.getInstance();
        if (birthDate != null) {
            cal.setTime(birthDate);
        }
        String sYear = String.valueOf(cal.get(1));
        idCard18 = idCard.substring(0, 6) + sYear + idCard.substring(8);
        char[] cArr = idCard18.toCharArray();
        if (cArr == null) return idCard18;
        int[] iCard = IDCardUtil.converCharToInt(cArr);
        int iSum17 = IDCardUtil.getPowerSum(iCard);
        String sVal = IDCardUtil.getCheckCode18(iSum17);
        if (sVal.length() <= 0) return null;
        return idCard18 + sVal;
    }

    public static boolean validateIDCardByRegex(String idCard) {
        String curYear = "" + Calendar.getInstance().get(1);
        int y3 = Integer.valueOf(curYear.substring(2, 3));
        int y4 = Integer.valueOf(curYear.substring(3, 4));
        return idCard.matches("^(1[1-5]|2[1-3]|3[1-7]|4[1-6]|5[0-4]|6[1-5]|71|8[1-2])\\d{4}(19\\d{2}|20([0-" + (y3 - 1) + "][0-9]|" + y3 + "[0-" + y4 + "]))(((0[1-9]|1[0-2])(0[1-9]|[1-2][0-9]|3[0-1])))\\d{3}([0-9]|x|X)$");
    }

    public static boolean validateIdCard(String idCard) {
        String card = idCard.trim();
        if (IDCardUtil.validateIdCard18(card)) {
            return true;
        }
        return IDCardUtil.validateIdCard15(card);
    }

    public static boolean validateIdCard18(String idCard) {
        boolean bTrue = false;
        if (idCard.length() == 18) {
            int[] iCard;
            int iSum17;
            String val;
            char[] cArr;
            String code17 = idCard.substring(0, 17);
            String code18 = idCard.substring(17, 18);
            if (IDCardUtil.isNum(code17) && (cArr = code17.toCharArray()) != null && (val = IDCardUtil.getCheckCode18(iSum17 = IDCardUtil.getPowerSum(iCard = IDCardUtil.converCharToInt(cArr)))).length() > 0 && val.equalsIgnoreCase(code18)) {
                bTrue = true;
            }
        }
        return bTrue && IDCardUtil.validateIDCardByRegex(idCard) && IDCardUtil.getProvinceByIdCard(idCard) != null;
    }

    public static boolean validateIdCard15(String idCard) {
        if (idCard.length() != 15) {
            return false;
        }
        if (IDCardUtil.isNum(idCard)) {
            String proCode = idCard.substring(0, 2);
            if (cityCodes.get(proCode) == null) {
                return false;
            }
            String birthCode = idCard.substring(6, 12);
            Date birthDate = null;
            try {
                birthDate = new SimpleDateFormat("yy").parse(birthCode.substring(0, 2));
            }
            catch (ParseException e) {
                logger.error(e.toString(), (Throwable)e);
            }
            Calendar cal = Calendar.getInstance();
            if (birthDate != null) {
                cal.setTime(birthDate);
            }
            return IDCardUtil.valiDate(cal.get(1), Integer.valueOf(birthCode.substring(2, 4)), Integer.valueOf(birthCode.substring(4, 6)));
        }
        return false;
    }

    public static boolean validateTWCard(String idCard) {
        String start = idCard.substring(0, 1);
        String mid = idCard.substring(1, 9);
        String end = idCard.substring(9, 10);
        Integer iStart = twFirstCode.get(start);
        Integer sum = iStart / 10 + iStart % 10 * 9;
        char[] chars = mid.toCharArray();
        Integer iflag = 8;
        for (char c : chars) {
            sum = sum + Integer.valueOf(c + "") * iflag;
            Integer n = iflag;
            Integer n2 = iflag = Integer.valueOf(iflag - 1);
        }
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.valueOf(end);
    }

    public static boolean validateHKCard(String idCard) {
        String card = idCard.replaceAll("[\\(|\\)]", "");
        Integer sum = 0;
        if (card.length() == 9) {
            sum = (Integer.valueOf(card.substring(0, 1).toUpperCase().toCharArray()[0]) - 55) * 9 + (Integer.valueOf(card.substring(1, 2).toUpperCase().toCharArray()[0]) - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (Integer.valueOf(card.substring(0, 1).toUpperCase().toCharArray()[0]) - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        Integer iflag = 7;
        for (char c : chars) {
            sum = sum + Integer.valueOf(c + "") * iflag;
            Integer n = iflag;
            Integer n2 = iflag = Integer.valueOf(iflag - 1);
        }
        sum = end.toUpperCase().equals("A") ? Integer.valueOf(sum + 10) : Integer.valueOf(sum + Integer.valueOf(end));
        return sum % 11 == 0;
    }

    public static int[] converCharToInt(char[] ca) {
        int len = ca.length;
        int[] iArr = new int[len];
        try {
            for (int i = 0; i < len; ++i) {
                iArr[i] = Integer.parseInt(String.valueOf(ca[i]));
            }
        }
        catch (NumberFormatException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        return iArr;
    }

    public static int getPowerSum(int[] iArr) {
        int iSum = 0;
        if (power.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                for (int j = 0; j < power.length; ++j) {
                    if (i != j) continue;
                    iSum += iArr[i] * power[j];
                }
            }
        }
        return iSum;
    }

    public static String getCheckCode18(int iSum) {
        String sCode = "";
        switch (iSum % 11) {
            case 10: {
                sCode = "2";
                break;
            }
            case 9: {
                sCode = "3";
                break;
            }
            case 8: {
                sCode = "4";
                break;
            }
            case 7: {
                sCode = "5";
                break;
            }
            case 6: {
                sCode = "6";
                break;
            }
            case 5: {
                sCode = "7";
                break;
            }
            case 4: {
                sCode = "8";
                break;
            }
            case 3: {
                sCode = "9";
                break;
            }
            case 2: {
                sCode = "x";
                break;
            }
            case 1: {
                sCode = "0";
                break;
            }
            case 0: {
                sCode = "1";
            }
        }
        return sCode;
    }

    public static int getAgeByIdCard(String idNo) {
        try {
            Calendar currentDate = Calendar.getInstance();
            int bornYear = Integer.valueOf(idNo.substring(6, 10));
            int bornMonth = Integer.valueOf(idNo.substring(10, 12));
            int bornDay = Integer.valueOf(idNo.substring(12, 14));
            int currentYear = currentDate.get(1);
            int currentMonth = currentDate.get(2) + 1;
            int currentDay = currentDate.get(5);
            int age = currentYear - bornYear;
            if (bornMonth > currentMonth || bornMonth == currentMonth && bornDay > currentDay) {
                --age;
            }
            return age;
        }
        catch (Throwable e) {
            String errMsg = String.format("\u5e74\u9f84\u8ba1\u7b97\u5931\u8d25, idNo:%s", idNo);
            logger.error(errMsg);
            throw new RuntimeException(errMsg, e);
        }
    }

    public static String getBirthByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtil.conver15CardTo18(idCard);
        }
        return idCard.substring(6, 14);
    }

    public static String getBirthFormatByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtil.conver15CardTo18(idCard);
        }
        return idCard.substring(6, 10) + "-" + idCard.substring(10, 12) + "-" + idCard.substring(12, 14);
    }

    public static Short getYearByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtil.conver15CardTo18(idCard);
        }
        return Short.valueOf(idCard.substring(6, 10));
    }

    public static Short getMonthByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtil.conver15CardTo18(idCard);
        }
        return Short.valueOf(idCard.substring(10, 12));
    }

    public static Short getDateByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtil.conver15CardTo18(idCard);
        }
        return Short.valueOf(idCard.substring(12, 14));
    }

    public static String getGenderByIdCard(String idCard) {
        String sCardNum;
        String sGender = "N";
        if (idCard.length() == 15) {
            idCard = IDCardUtil.conver15CardTo18(idCard);
        }
        sGender = Integer.parseInt(sCardNum = idCard.substring(16, 17)) % 2 != 0 ? "M" : "F";
        return sGender;
    }

    public static String getProvinceByIdCard(String idCard) {
        int len = idCard.length();
        String provCode = null;
        String sProvinNum = "";
        if (len == 15 || len == 18) {
            sProvinNum = idCard.substring(0, 2);
        }
        provCode = cityCodes.get(sProvinNum);
        return provCode;
    }

    public static boolean isNum(String val) {
        return NumberUtils.isCreatable((String)val);
    }

    public static boolean valiDate(int iYear, int iMonth, int iDate) {
        int datePerMonth;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        if (iYear < 1930 || iYear >= year) {
            return false;
        }
        if (iMonth < 1 || iMonth > 12) {
            return false;
        }
        switch (iMonth) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                datePerMonth = 30;
                break;
            }
            case 2: {
                boolean dm = (iYear % 4 == 0 && iYear % 100 != 0 || iYear % 400 == 0) && iYear > 1930 && iYear < year;
                datePerMonth = dm ? 29 : 28;
                break;
            }
            default: {
                datePerMonth = 31;
            }
        }
        return iDate >= 1 && iDate <= datePerMonth;
    }

    public static String getConstellationById(String idCard) {
        if (!IDCardUtil.validateIdCard(idCard)) {
            return "";
        }
        short month = IDCardUtil.getMonthByIdCard(idCard);
        short day = IDCardUtil.getDateByIdCard(idCard);
        String strValue = "";
        if (month == 1 && day >= 20 || month == 2 && day <= 18) {
            strValue = "\u6c34\u74f6\u5ea7";
        } else if (month == 2 && day >= 19 || month == 3 && day <= 20) {
            strValue = "\u53cc\u9c7c\u5ea7";
        } else if (month == 3 && day > 20 || month == 4 && day <= 19) {
            strValue = "\u767d\u7f8a\u5ea7";
        } else if (month == 4 && day >= 20 || month == 5 && day <= 20) {
            strValue = "\u91d1\u725b\u5ea7";
        } else if (month == 5 && day >= 21 || month == 6 && day <= 21) {
            strValue = "\u53cc\u5b50\u5ea7";
        } else if (month == 6 && day > 21 || month == 7 && day <= 22) {
            strValue = "\u5de8\u87f9\u5ea7";
        } else if (month == 7 && day > 22 || month == 8 && day <= 22) {
            strValue = "\u72ee\u5b50\u5ea7";
        } else if (month == 8 && day >= 23 || month == 9 && day <= 22) {
            strValue = "\u5904\u5973\u5ea7";
        } else if (month == 9 && day >= 23 || month == 10 && day <= 23) {
            strValue = "\u5929\u79e4\u5ea7";
        } else if (month == 10 && day > 23 || month == 11 && day <= 22) {
            strValue = "\u5929\u874e\u5ea7";
        } else if (month == 11 && day > 22 || month == 12 && day <= 21) {
            strValue = "\u5c04\u624b\u5ea7";
        } else if (month == 12 && day > 21 || month == 1 && day <= 19) {
            strValue = "\u9b54\u7faf\u5ea7";
        }
        return strValue;
    }

    public static String getZodiacById(String idCard) {
        if (!IDCardUtil.validateIdCard(idCard)) {
            return "";
        }
        String[] sSX = new String[]{"\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7"};
        short year = IDCardUtil.getYearByIdCard(idCard);
        int end = 3;
        int x = (year - end) % 12;
        String retValue = "";
        retValue = sSX[x];
        return retValue;
    }

    public static String getChineseEraById(String idCard) {
        if (!IDCardUtil.validateIdCard(idCard)) {
            return "";
        }
        String[] sTG = new String[]{"\u7678", "\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u4efb"};
        String[] sDZ = new String[]{"\u4ea5", "\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c"};
        short year = IDCardUtil.getYearByIdCard(idCard);
        int i = (year - 3) % 10;
        int j = (year - 3) % 12;
        String retValue = "";
        retValue = sTG[i] + sDZ[j];
        return retValue;
    }

    static {
        cityCodes.put("11", "\u5317\u4eac");
        cityCodes.put("12", "\u5929\u6d25");
        cityCodes.put("13", "\u6cb3\u5317");
        cityCodes.put("14", "\u5c71\u897f");
        cityCodes.put("15", "\u5185\u8499\u53e4");
        cityCodes.put("21", "\u8fbd\u5b81");
        cityCodes.put("22", "\u5409\u6797");
        cityCodes.put("23", "\u9ed1\u9f99\u6c5f");
        cityCodes.put("31", "\u4e0a\u6d77");
        cityCodes.put("32", "\u6c5f\u82cf");
        cityCodes.put("33", "\u6d59\u6c5f");
        cityCodes.put("34", "\u5b89\u5fbd");
        cityCodes.put("35", "\u798f\u5efa");
        cityCodes.put("36", "\u6c5f\u897f");
        cityCodes.put("37", "\u5c71\u4e1c");
        cityCodes.put("41", "\u6cb3\u5357");
        cityCodes.put("42", "\u6e56\u5317");
        cityCodes.put("43", "\u6e56\u5357");
        cityCodes.put("44", "\u5e7f\u4e1c");
        cityCodes.put("45", "\u5e7f\u897f");
        cityCodes.put("46", "\u6d77\u5357");
        cityCodes.put("50", "\u91cd\u5e86");
        cityCodes.put("51", "\u56db\u5ddd");
        cityCodes.put("52", "\u8d35\u5dde");
        cityCodes.put("53", "\u4e91\u5357");
        cityCodes.put("54", "\u897f\u85cf");
        cityCodes.put("61", "\u9655\u897f");
        cityCodes.put("62", "\u7518\u8083");
        cityCodes.put("63", "\u9752\u6d77");
        cityCodes.put("64", "\u5b81\u590f");
        cityCodes.put("65", "\u65b0\u7586");
        cityCodes.put("71", "\u53f0\u6e7e");
        cityCodes.put("81", "\u9999\u6e2f");
        cityCodes.put("82", "\u6fb3\u95e8");
        cityCodes.put("91", "\u56fd\u5916");
        twFirstCode.put("A", 10);
        twFirstCode.put("B", 11);
        twFirstCode.put("C", 12);
        twFirstCode.put("D", 13);
        twFirstCode.put("E", 14);
        twFirstCode.put("F", 15);
        twFirstCode.put("G", 16);
        twFirstCode.put("H", 17);
        twFirstCode.put("J", 18);
        twFirstCode.put("K", 19);
        twFirstCode.put("L", 20);
        twFirstCode.put("M", 21);
        twFirstCode.put("N", 22);
        twFirstCode.put("P", 23);
        twFirstCode.put("Q", 24);
        twFirstCode.put("R", 25);
        twFirstCode.put("S", 26);
        twFirstCode.put("T", 27);
        twFirstCode.put("U", 28);
        twFirstCode.put("V", 29);
        twFirstCode.put("X", 30);
        twFirstCode.put("Y", 31);
        twFirstCode.put("W", 32);
        twFirstCode.put("Z", 33);
        twFirstCode.put("I", 34);
        twFirstCode.put("O", 35);
        hkFirstCode.put("A", 1);
        hkFirstCode.put("B", 2);
        hkFirstCode.put("C", 3);
        hkFirstCode.put("R", 18);
        hkFirstCode.put("U", 21);
        hkFirstCode.put("Z", 26);
        hkFirstCode.put("X", 24);
        hkFirstCode.put("W", 23);
        hkFirstCode.put("O", 15);
        hkFirstCode.put("N", 14);
    }
}

