/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.time;

import com.rocoinfo.utils.base.annotation.NotNull;
import com.rocoinfo.utils.time.DateFormatUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;

public final class DateUtil {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    static final String[] weekOfDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    private static final int[] MONTH_LENGTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static boolean isSameDay(@NotNull Date date1, @NotNull Date date2) {
        return DateUtils.isSameDay((Date)date1, (Date)date2);
    }

    public static boolean isSameTime(@NotNull Date date1, @NotNull Date date2) {
        return DateUtil.compareDate(date1, date2) == 0;
    }

    public static boolean isBetween(@NotNull Date date, @NotNull Date start, @NotNull Date end) {
        if (date == null || start == null || end == null || start.after(end)) {
            throw new IllegalArgumentException("some date parameters is null or dateBein after dateEnd");
        }
        return !date.before(start) && !date.after(end);
    }

    public static int compareDate(@NotNull Date date1, @NotNull Date date2) {
        int rnum = date1.compareTo(date2);
        return rnum;
    }

    public static int getIntervalDays(LocalDate startDate, LocalDate endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        return (int)(endDate.toEpochDay() - startDate.toEpochDay());
    }

    public static int getWeekOfMonth(@NotNull Date date) {
        return DateUtil.getWithMondayFirst(date, 4);
    }

    public static int getWeekOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(3);
    }

    public static int getDayOfWeek(@NotNull Date date) {
        int result = DateUtil.getWithMondayFirst(date, 7);
        return result == 1 ? 7 : result - 1;
    }

    public static String getWeekOfDate(Date date) {
        int w;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return weekOfDays[w];
    }

    public static int getDayOfYear(@NotNull Date date) {
        return DateUtil.get(date, 6);
    }

    public static boolean isLeapYear(@NotNull Date date) {
        return DateUtil.isLeapYear(DateUtil.get(date, 1));
    }

    public static boolean isLeapYear(int year) {
        if (year % 400 == 0) {
            return true;
        }
        return year % 100 != 0 && year % 4 == 0;
    }

    public static int getMonthLength(@NotNull Date date) {
        int year = DateUtil.get(date, 1);
        int month = DateUtil.get(date, 2);
        return DateUtil.getMonthLength(year, month);
    }

    public static int getMonthLength(int year, int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month: " + month);
        }
        if (month == 2) {
            return DateUtil.isLeapYear(year) ? 29 : 28;
        }
        return MONTH_LENGTH[month];
    }

    public static String getNowDateTime() {
        return DateFormatUtil.formatToDateTime(new Date());
    }

    public static String getYearMonth() {
        return DateFormatUtil.formatDate(new Date(), "yyyy-MM");
    }

    public static String unixTimestampToDate(long timestamp) {
        return DateFormatUtil.formatToDateTime(new Date(timestamp));
    }

    public static Date currentMonthFirstDay() {
        return DateUtil.monthFirstDay(new Date());
    }

    public static Date monthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date weekFirstDay(Date date) {
        int dayOfWeek;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        int offset = (dayOfWeek = calendar.get(7)) == 1 ? -6 : 2 - dayOfWeek;
        calendar.add(7, offset);
        return calendar.getTime();
    }

    public static Date weekLastDay(Date date) {
        int dayOfWeek;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        int offset = (dayOfWeek = calendar.get(7)) == 1 ? 0 : 7 - dayOfWeek + 1;
        calendar.add(7, offset);
        return calendar.getTime();
    }

    public static Date localDateTimeToDate(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date localDateToDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        return Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        return DateFormatUtil.parseToLocalDateTime(date);
    }

    public static LocalDate dateToLocalDate(Date date) {
        return DateFormatUtil.parseToLocalDate(date);
    }

    public static Date beginOfYear(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)1);
    }

    public static Date endOfYear(@NotNull Date date) {
        return new Date(DateUtil.nextYear(date).getTime() - 1L);
    }

    public static Date nextYear(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)1);
    }

    public static Date beginOfMonth(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)2);
    }

    public static Date endOfMonth(@NotNull Date date) {
        return new Date(DateUtil.nextMonth(date).getTime() - 1L);
    }

    public static Date nextMonth(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)2);
    }

    public static Date beginOfWeek(@NotNull Date date) {
        int amount = DateUtil.getDayOfWeek(date) - 1;
        return DateUtils.truncate((Date)DateUtils.addDays((Date)date, (int)(-amount)), (int)5);
    }

    public static Date endOfWeek(@NotNull Date date) {
        return new Date(DateUtil.nextWeek(date).getTime() - 1L);
    }

    public static Date nextWeek(@NotNull Date date) {
        int amount = 8 - DateUtil.getDayOfWeek(date);
        return DateUtils.truncate((Date)DateUtils.addDays((Date)date, (int)amount), (int)5);
    }

    public static Date beginOfDate(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    public static Date endOfDate(@NotNull Date date) {
        return new Date(DateUtil.nextDate(date).getTime() - 1L);
    }

    public static Date nextDate(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)5);
    }

    public static Date beginOfHour(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)11);
    }

    public static Date endOfHour(@NotNull Date date) {
        return new Date(DateUtil.nextHour(date).getTime() - 1L);
    }

    public static Date nextHour(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)11);
    }

    public static Date beginOfMinute(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)12);
    }

    public static Date endOfMinute(@NotNull Date date) {
        return new Date(DateUtil.nextMinute(date).getTime() - 1L);
    }

    public static Date nextMinute(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)12);
    }

    private static int get(Date date, int field) {
        Validate.notNull((Object)date, (String)"The date must not be null", (Object[])new Object[0]);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(field);
    }

    private static int getWithMondayFirst(Date date, int field) {
        Validate.notNull((Object)date, (String)"The date must not be null", (Object[])new Object[0]);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        return cal.get(field);
    }
}

