/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.time;

import com.rocoinfo.utils.base.annotation.NotNull;
import com.rocoinfo.utils.time.ClockUtil;
import com.rocoinfo.utils.time.DateUtil;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.ocpsoft.prettytime.PrettyTime;

public class PrettyTimeUtil {
    public static String formatFriendlyTimeSpanByNow(@NotNull Date date) {
        return PrettyTimeUtil.formatFriendlyTimeSpanByNow(date.getTime());
    }

    public static String formatFriendlyTimeSpanByNow(long timeStampMillis) {
        long now = ClockUtil.currentTimeMillis();
        long span = now - timeStampMillis;
        if (span < 0L) {
            return String.format("%tc", timeStampMillis);
        }
        if (span < 1000L) {
            return "\u521a\u521a";
        }
        if (span < 60000L) {
            return String.format("%d\u79d2\u524d", span / 1000L);
        }
        if (span < 3600000L) {
            return String.format("%d\u5206\u949f\u524d", span / 60000L);
        }
        long wee = DateUtil.beginOfDate(new Date(now)).getTime();
        if (timeStampMillis >= wee) {
            return String.format("\u4eca\u5929%tR", timeStampMillis);
        }
        if (timeStampMillis >= wee - 86400000L) {
            return String.format("\u6628\u5929%tR", timeStampMillis);
        }
        return String.format("%tF", timeStampMillis);
    }

    public static final String prettySeconds(int totalSeconds) {
        StringBuilder s = new StringBuilder();
        int second = totalSeconds % 60;
        if (totalSeconds > 0) {
            s.append("\u79d2");
            s.append(StringUtils.reverse((String)String.valueOf(second)));
        }
        int minute = (totalSeconds /= 60) % 60;
        if (totalSeconds > 0) {
            s.append("\u5206");
            s.append(StringUtils.reverse((String)String.valueOf(minute)));
        }
        int hour = (totalSeconds /= 60) % 24;
        if (totalSeconds > 0) {
            s.append(StringUtils.reverse((String)"\u5c0f\u65f6"));
            s.append(StringUtils.reverse((String)String.valueOf(hour)));
        }
        int day = (totalSeconds /= 24) % 31;
        if (totalSeconds > 0) {
            s.append("\u5929");
            s.append(StringUtils.reverse((String)String.valueOf(day)));
        }
        int month = (totalSeconds /= 31) % 12;
        if (totalSeconds > 0) {
            s.append("\u6708");
            s.append(StringUtils.reverse((String)String.valueOf(month)));
        }
        int year = totalSeconds /= 12;
        if (totalSeconds > 0) {
            s.append("\u5e74");
            s.append(StringUtils.reverse((String)String.valueOf(year)));
        }
        return s.reverse().toString();
    }

    public static final String prettyTime(Date date) {
        PrettyTime p = new PrettyTime();
        return p.format(date);
    }

    public static final String prettyTime(long millisecond) {
        PrettyTime p = new PrettyTime();
        return p.format(new Date(millisecond));
    }
}

