package com.rocoinfo.util;
 
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 *@author zhangmin
 */
public final class CookieUtil {

   public static final String SSO_TOKEN_COOKIE_NAME = "JJCToken16";

   /**
    * 添加cookie
    * @param response
    * @param name 不能为null
    * @param value 默认值空字符串
    * @param maxAge 默认值0,单位秒
    * @param path 默认值'/'
    */
   public static void addCookie(HttpServletResponse response, String name, String value,
                   Integer maxAge, String path,String domain) {

       //maxAge等于0,则指示浏览器立即删除该cookie;则默认maxAge是-1，则表示只要浏览器关闭删除cookie
       if (maxAge == null) {
           maxAge = 0;
       }

       if (value == null) {
           value = StringUtils.EMPTY;
       }

       if (path == null) {
           path = "/";
       }
       
       Cookie cookie = new Cookie(name, value);
       cookie.setMaxAge(maxAge);
       cookie.setPath(path);
       //如网址为www.jb51.net/test/test.aspx，那么domain 默认为www.jb51.net
       if(StringUtils.isNotEmpty(domain)) {
           cookie.setDomain(domain);
       }
       response.addCookie(cookie);
   }
   
   
   public static void removeCookie(HttpServletResponse response,String cookieName,String cookiePath,String domain) {
       CookieUtil.addCookie(response, cookieName, StringUtils.EMPTY, 0, cookiePath,domain);
   }


   public static void addLoginCookie(HttpServletResponse response,String value,int maxAge,String domain) {
       CookieUtil.addCookie(response,SSO_TOKEN_COOKIE_NAME,value,maxAge,null,domain);
   }

   public static void removeLoginCookie(HttpServletResponse response,String domain) {
       CookieUtil.removeCookie(response,SSO_TOKEN_COOKIE_NAME,null,domain);
   }

    public static String getLoginCookieValue(HttpServletRequest request){
        Cookie cookie =  getCookie(request,SSO_TOKEN_COOKIE_NAME);
        if(cookie!=null){
            return cookie.getValue();
        }
        return StringUtils.EMPTY;
    }

 
   /**
    * @param request
    * @param cookieName
    * @return 指定的cookie
    */
   public static Cookie getCookie(HttpServletRequest request, String cookieName){
       return readCookieMap(request).get(cookieName);
   }
   
   

   public static Map<String, Cookie> readCookieMap(HttpServletRequest request){
        Map<String, Cookie> cookieMap = Maps.newLinkedHashMap();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (int i = 0; i < cookies.length; i++) {
                cookieMap.put(cookies[i].getName(), cookies[i]);
            }
        }
        return cookieMap;
    }
   



}