package com.rocoinfo.utils;


import com.rocoinfo.utils.des.Digests;
import com.rocoinfo.utils.des.Encodes;
import org.apache.commons.lang3.StringUtils;

/**
 * <dl>
 * <dd>Description: 密码加密工具类</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/7 16:21</dd>
 * <dd>@author：Kong</dd>
 * </dl>
 */
public class PasswordUtil {
    private static final int SALT_SIZE = 8;
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_ITERATIONS = 1024;

    /**
     * 密码加密
     * @param plainPassword 明文密码
     * @param salt     盐值
     * @return 返回加密后的密码
     */
    public static String entryptPassword(String plainPassword, String salt) {
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), Encodes.decodeHex(salt), HASH_ITERATIONS);
        return Encodes.encodeHex(hashPassword);
    }

    /**
     * 生成密码的盐
     * @return
     */
    public static String generateSalt() {
        byte[] salt = Digests.generateSalt(SALT_SIZE);
        return Encodes.encodeHex(salt);
    }

    /**
     * 密码是否正确
     *
     * @param plainPassword 明文密码
     * @param salt     盐值
     * @param hashPassword 加密后的密码（数据库中保存的密码）
     * @return 返回密码是否正确
     */
    public static boolean isCorrect(String plainPassword, String salt,String hashPassword) {
        return StringUtils.equals(entryptPassword(plainPassword,salt),hashPassword);
    }

}
