package com.rocoinfo.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * 驼峰法-下划线互转
 */
public final class Underline2Camel {

    private static final char SEPARATOR = '_';

    /**
     * 下划线转驼峰法
     * @param underlineStr
     */
    public static String underline2Camel(String underlineStr) {
        if (underlineStr == null) {
            return null;
        }
        underlineStr = underlineStr.toLowerCase();
        StringBuilder sb = new StringBuilder(underlineStr.length());
        boolean upperCase = false;
        for (int i = 0; i < underlineStr.length(); i++) {
            char c = underlineStr.charAt(i);
            if (c == SEPARATOR) {
                upperCase = true;
            } else if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }


    /**驼峰法转下划线
     * @param camelStr
     * @return  startTime 转成=> start_time;
     *         status=>status;
     *         purchaseOrder.unlockQuantity=> purchaseOrder.unlock_quantity;
     *         product_id=> product_id
     */
    public static String camel2UnderlineLowerCase(String camelStr) {
        if(camelStr == null) {
            return null;
        }

        String dot = ".";
        boolean containPrefix = camelStr.contains(dot);
        String prefix  = StringUtils.EMPTY;
        if(containPrefix) {
            //如果camelStr中有字符.,  则把点后面的字段转换成下划线格式
            prefix = StringUtils.substringBefore(camelStr,dot) + dot;
            camelStr = StringUtils.substringAfter(camelStr,dot);
        }


        StringBuilder sb = new StringBuilder(prefix);
        boolean upperCase = false;
        for (int i = 0; i < camelStr.length(); i++) {
            char c = camelStr.charAt(i);

            boolean nextUpperCase = true;

            if (i < (camelStr.length() - 1)) {
                nextUpperCase = Character.isUpperCase(camelStr.charAt(i + 1));
            }

            if ((i >= 0) && Character.isUpperCase(c)) {
                if (!upperCase || !nextUpperCase) {
                    if (i > 0) sb.append(SEPARATOR);
                }
                upperCase = true;
            } else {
                upperCase = false;
            }

            sb.append(Character.toLowerCase(c));
        }

        return sb.toString();
    }

    /**
     * 转成驼峰风格字符串，并且首字母大写
     * @param underlineStr
     * @return
     */
    public static String toCapitalizeCamelCase(String underlineStr) {
        if (underlineStr == null) {
            return null;
        }

        String camelStr = underline2Camel(underlineStr);
        return camelStr.substring(0, 1).toUpperCase() + camelStr.substring(1);
    }

}