package com.rocoinfo.utils.des;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.util.Base64;

public final class AESUtil {

    /**
     * 加密内容
     * @param content 加密内容
     * @param strKey 加密 密钥
     * @param ivKey 初始化内容 (16位)
     * @return 返回加密后内容
     * @throws Exception
     */
    public static String encrypt(String content,String strKey, String ivKey) throws Exception {
        SecretKeySpec skeySpec = getKey(strKey);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec iv = new IvParameterSpec(ivKey.getBytes());
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);
        byte[] encrypted = cipher.doFinal(content.getBytes());
        return  bytesToString(encrypted);
    }

    /**
     * 解密内容
     * @param content 加密内容
     * @param strKey 解密 密钥
     * @param ivKey 初始化内容 (16位)
     * @return 解密后内容
     * @throws Exception
     */
    public static String decrypt(String content,String strKey, String ivKey) throws Exception {
        SecretKeySpec skeySpec = getKey(strKey);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec iv = new IvParameterSpec(ivKey.getBytes());
        cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);
        byte[] original = cipher.doFinal(stringToBytes(content));
        String originalString = new String(original);
        return originalString;
    }

    /**
     * 返回加密对象
     * @param strKey
     * @return
     * @throws Exception
     */
    private static SecretKeySpec getKey(String strKey) throws Exception {
        byte[] arrBTmp = strKey.getBytes();
        byte[] arrB = new byte[16]; // 创建一个空的16位字节数组（默认值为0）

        for (int i = 0; i < arrBTmp.length && i < arrB.length; i++) {
            arrB[i] = arrBTmp[i];
        }

        SecretKeySpec skeySpec = new SecretKeySpec(arrB, "AES");

        return skeySpec;
    }

    /**
     * 字节数组转化为字符串
     * @param content
     * @return
     */
    private static String bytesToString(byte[] content) {
        return Base64.getEncoder().encodeToString(content);
    }

    /**
     * 字符串转为字节数组
     * @param content
     * @return
     */
    private static byte[] stringToBytes(String content) {
        return Base64.getDecoder().decode(content);
    }
}
