package com.rocoinfo.utils.img;

import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.util.Config;
import com.rocoinfo.utils.io.FileUtil;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Properties;

/**
 * <dl>
 * <dd>图形验证码工具类</dd>
 * </dl>
 */
public class KaptchaUtil {

    private static Producer kaptchaProducer = null;
    private static String sessionKeyValue = null;
    private static String sessionKeyDateValue = null;

    static {
        Properties props = new Properties();
        Config cfg = new Config(props);
        KaptchaUtil.kaptchaProducer = cfg.getProducerImpl();
        KaptchaUtil.sessionKeyValue = cfg.getSessionKey();
        KaptchaUtil.sessionKeyDateValue = cfg.getSessionDate();
    }

    public static Producer getKaptchaProducer() {
        return kaptchaProducer;
    }


    /**
     *  默认值：com.google.code.kaptcha.Constants.KAPTCHA_SESSION_KEY
     * 获得验证码的放入session中的key
     * @return
     */
    public static String getSessionKeyValue() {
        return sessionKeyValue;
    }

    public static String getSessionKeyDateValue() {
        return sessionKeyDateValue;
    }

    /**
     * 生成图片验证码
     * @return 生成的 验证码文字
     */
    public static String generateKaptchaImage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setDateHeader("Expires", 0);
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.addHeader("Cache-Control", "post-check=0, pre-check=0");
        resp.setHeader("Pragma", "no-cache");
        resp.setContentType("image/jpeg");
        //生成验证码
        String capText = kaptchaProducer.createText();
        req.getSession().setAttribute(getSessionKeyValue(), capText);
        //向客户端写出
        BufferedImage bufImg = kaptchaProducer.createImage(capText);
        ServletOutputStream out = resp.getOutputStream();
        try {
            ImageIO.write(bufImg, "jpg", out);
            out.flush();
        } finally {
            FileUtil.closeIO(out);
        }

        return capText;
    }

}