package com.rocoinfo.utils.text;

import com.rocoinfo.utils.base.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

/**
 * 尽量使用Common Lang StringUtils, 基本覆盖了所有类库的StringUtils
 * 
 * 本类仅补充少量额外方法, 尤其是针对char的运算
 * 
 * 1. split char/chars
 * 
 * 2. 针对char的replace first/last, startWith,endWith 等
 * 
 * @author calvin
 */
public class StringUtil {
    ////////// 其他 char 相关 ///////////
    /**
     * String 有replace(char,char)，但缺少单独replace first/last的
     */
    public static String replaceFirst(@Nullable String s, char sub, char with) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(sub);
        if (index == -1) {
            return s;
        }
        char[] str = s.toCharArray();
        str[index] = with;
        return new String(str);
    }

    /**
     * String 有replace(char,char)替换全部char，但缺少单独replace first/last
     */
    public static String replaceLast(@Nullable String s, char sub, char with) {
        if (s == null) {
            return null;
        }

        int index = s.lastIndexOf(sub);
        if (index == -1) {
            return s;
        }
        char[] str = s.toCharArray();
        str[index] = with;
        return new String(str);
    }

    /**
     * 判断字符串是否以字母结尾
     *
     * 如果字符串为Null或空，返回false
     */
    public static boolean endWith(@Nullable CharSequence s, char c) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        return s.charAt(s.length() - 1) == c;
    }



    /**
     * 如果结尾字符为c, 去除掉该字符.
     */
    public static String removeEnd(final String s, final char c) {
        if (endWith(s, c)) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    /***过滤单引号和;和--，防止sql注入*/
    public static String filterQuote(String keyword) {
        if(keyword!=null) {
            keyword = keyword.replaceAll("'|’|‘|;|--|\"|“|”|%|(?i)\\bselect\\b|\\bdrop\\b|\\bdelete\\b|\\bexec", StringUtils.EMPTY);
        }
        return keyword;
    }

    /**判断字符串中每个字符都是中文字符**/
    public static boolean isChinese(String str) {
        if(StringUtils.isBlank(str))
            return false;
        return str.matches("[\u4e00-\u9FA5]+");
    }

}