package com.rocoinfo.utils.time;

import java.util.Date;

public class ClockUtil {

    private static Clock instance = new DefaultClock();
    /**
     * 计算流逝的时间
     */
    public static long elapsedTime(long beginTime) {
        return currentTimeMillis() - beginTime;
    }



    /**
     * 系统当前时间
     */
    public static Date currentDate() {
        return instance.currentDate();
    }

    /**
     * 系统当前时间戳
     */
    public static long currentTimeMillis() {
        return instance.currentTimeMillis();
    }

    /**
     * 操作系统启动到现在的纳秒数，与系统时间是完全独立的两个时间体系
     */
    public static long nanoTime() {
        return instance.nanoTime();
    }

    public interface Clock {

        /**
         * 系统当前时间
         */
        Date currentDate();

        /**
         * 系统当前时间戳
         */
        long currentTimeMillis();

        /**
         * 操作系统启动到现在的纳秒数，与系统时间是完全独立的两个时间体系
         */
        long nanoTime();
    }
    /**
     * 默认时间提供者，返回当前的时间，线程安全。
     */
    public static class DefaultClock implements Clock {

        @Override
        public Date currentDate() {
            return new Date();
        }

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }
    }
}