/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils;

import com.rocoinfo.utils.des.Digests;
import com.rocoinfo.utils.des.Encodes;
import org.apache.commons.lang3.StringUtils;

public class PasswordUtil {
    private static final int SALT_SIZE = 8;
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_ITERATIONS = 1024;

    public static String entryptPassword(String plainPassword, String salt) {
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), Encodes.decodeHex(salt), 1024);
        return Encodes.encodeHex(hashPassword);
    }

    public static String generateSalt() {
        byte[] salt = Digests.generateSalt(8);
        return Encodes.encodeHex(salt);
    }

    public static boolean isCorrect(String plainPassword, String salt, String hashPassword) {
        return StringUtils.equals((CharSequence)PasswordUtil.entryptPassword(plainPassword, salt), (CharSequence)hashPassword);
    }
}

