/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.collection;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MapUtil {
    private MapUtil() {
    }

    public static void putNotNull(Map<String, Object> map, String key, Object value) {
        if (map == null || value == null) {
            return;
        }
        if (value instanceof String) {
            if (StringUtils.isNotBlank((CharSequence)((String)value))) {
                map.put(key, ((String)value).trim());
            }
        } else {
            map.put(key, value);
        }
    }

    public static void putOrElse(Map<String, Object> map, String key, Object value, Object defaultVal) {
        if (map == null || StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        if (value == null) {
            map.put(key, defaultVal);
            return;
        }
        if (value instanceof String) {
            if (StringUtils.isNotBlank((CharSequence)((String)value))) {
                map.put(key, ((String)value).trim());
            } else {
                map.put(key, defaultVal);
            }
        } else {
            map.put(key, value);
        }
    }

    public static <K, V> Map<K, V> of(K k, V v) {
        HashMap map = new HashMap();
        MapUtil.checkNotNullAndPut(map, k, v);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        HashMap map = new HashMap();
        MapUtil.checkNotNullAndPut(map, k1, v1);
        MapUtil.checkNotNullAndPut(map, k2, v2);
        return map;
    }

    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        return Maps.difference(left, right);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap map = new HashMap();
        MapUtil.checkNotNullAndPut(map, k1, v1);
        MapUtil.checkNotNullAndPut(map, k2, v2);
        MapUtil.checkNotNullAndPut(map, k3, v3);
        return map;
    }

    private static <K, V> void checkNotNullAndPut(Map<K, V> map, K k, V v) {
        if (k != null && v != null) {
            map.put(k, v);
        }
    }
}

