/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.html;

import com.rocoinfo.utils.html.jsoup.SishuokCleaner;
import com.rocoinfo.utils.html.jsoup.SishuokWhitelist;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class HtmlUtil {
    public static String text(String html) {
        if (StringUtils.isEmpty((CharSequence)html)) {
            return html;
        }
        return Jsoup.parse((String)HtmlUtil.removeUnSafeTag(html).replace("&lt;", "<").replace("&gt;", ">")).text();
    }

    public static String text(String html, int maxLength) {
        String text = HtmlUtil.text(html);
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength) + "\u2026\u2026";
    }

    public static String removeUnSafeTag(String html) {
        SishuokWhitelist whitelist = new SishuokWhitelist();
        whitelist.addTags("embed", "object", "param", "span", "div", "img", "font", "del");
        whitelist.addTags("a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup");
        whitelist.addTags("dd", "dl", "dt", "em", "hr", "h1", "h2", "h3", "h4", "h5", "h6", "i", "img");
        whitelist.addTags("li", "ol", "p", "pre", "q", "small", "strike", "strong", "sub", "sup", "table");
        whitelist.addTags("tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul");
        whitelist.addAttributes(":all", "on");
        Document dirty = Jsoup.parseBodyFragment((String)html, (String)"");
        SishuokCleaner cleaner = new SishuokCleaner(whitelist);
        Document clean = cleaner.clean(dirty);
        return clean.body().html();
    }

    public static String removeTag(String html, String tagName) {
        Element bodyElement = Jsoup.parse((String)html).body();
        bodyElement.getElementsByTag(tagName).remove();
        return bodyElement.html();
    }
}

