/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.img;

import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.util.Config;
import com.rocoinfo.utils.io.FileUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KaptchaUtil {
    private static Producer kaptchaProducer = null;
    private static String sessionKeyValue = null;
    private static String sessionKeyDateValue = null;

    public static Producer getKaptchaProducer() {
        return kaptchaProducer;
    }

    public static String getSessionKeyValue() {
        return sessionKeyValue;
    }

    public static String getSessionKeyDateValue() {
        return sessionKeyDateValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateKaptchaImage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setDateHeader("Expires", 0L);
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.addHeader("Cache-Control", "post-check=0, pre-check=0");
        resp.setHeader("Pragma", "no-cache");
        resp.setContentType("image/jpeg");
        String capText = kaptchaProducer.createText();
        req.getSession().setAttribute(KaptchaUtil.getSessionKeyValue(), (Object)capText);
        BufferedImage bufImg = kaptchaProducer.createImage(capText);
        ServletOutputStream out = resp.getOutputStream();
        try {
            ImageIO.write((RenderedImage)bufImg, "jpg", (OutputStream)out);
            out.flush();
        }
        catch (Throwable throwable) {
            FileUtil.closeIO(new Closeable[]{out});
            throw throwable;
        }
        FileUtil.closeIO(new Closeable[]{out});
        return capText;
    }

    static {
        Properties props = new Properties();
        Config cfg = new Config(props);
        kaptchaProducer = cfg.getProducerImpl();
        sessionKeyValue = cfg.getSessionKey();
        sessionKeyDateValue = cfg.getSessionDate();
    }
}

